/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;

public class MultipleCheckboxOptionsPanel
extends InspectionOptionsPanel {
    private final OptionAccessor myOptionAccessor;

    public MultipleCheckboxOptionsPanel(InspectionProfileEntry owner) {
        this(new OptionAccessor.Default(owner));
    }

    public MultipleCheckboxOptionsPanel(OptionAccessor optionAccessor) {
        this.myOptionAccessor = optionAccessor;
    }

    public void addCheckbox(@NlsContexts.Checkbox String label, @NonNls String property) {
        this.addCheckboxEx(label, property);
    }

    public JCheckBox addCheckboxEx(@NlsContexts.Checkbox String label, @NonNls String property) {
        boolean selected = this.myOptionAccessor.getOption(property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        checkBox.addItemListener(e -> this.myOptionAccessor.setOption(property, e.getStateChange() == 1));
        this.addComponent(checkBox);
        return checkBox;
    }

    public JCheckBox addDependentCheckBox(@NlsContexts.Checkbox String label, @NonNls String property, JCheckBox controller2) {
        JCheckBox checkBox = this.addCheckboxEx(label, property);
        checkBox.setBorder(new EmptyBorder((Insets)new JBInsets(0, 20, 0, 0)));
        controller2.addItemListener(e -> checkBox.setEnabled(((JCheckBox)e.getSource()).isEnabled() && e.getStateChange() == 1));
        checkBox.setEnabled(controller2.isEnabled() && controller2.isSelected());
        return checkBox;
    }

    public void addComponent(JComponent component) {
        this.add((Component)component, "span, wrap, grow");
    }
}

