/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.XmlDomReader;
import com.intellij.util.XmlElement;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        XmlElement xmlElement;
        String filePath2;
        String prefix = System.getProperty("idea.platform.prefix", "");
        if (Boolean.getBoolean("idea.use.dev.build.server")) {
            String module = null;
            if (prefix.isEmpty() || prefix.equals("idea")) {
                module = "intellij.idea.ultimate.resources";
            } else if (prefix.equals("WebStorm")) {
                module = "intellij.webstorm";
            }
            filePath2 = module == null ? null : PathManager.getHomePath() + "/out/classes/production/" + module + "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        } else {
            filePath2 = PathManager.getBinPath() + "/appInfo.xml";
        }
        if (filePath2 != null) {
            XmlElement xmlElement2;
            Path file = Paths.get(filePath2, new String[0]);
            try {
                xmlElement2 = XmlDomReader.readXmlAsModel((InputStream)Files.newInputStream(file, new OpenOption[0]));
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load " + file, e);
            }
            if (xmlElement2 == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(0);
            }
            return xmlElement2;
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            xmlElement = XmlDomReader.readXmlAsModel((InputStream)stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
        if (xmlElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(1);
        }
        return xmlElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            XmlElement xmlElement = data;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (xmlElement == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(2);
            }
            return xmlElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result = instance;
        if (result == null) {
            Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
            // MONITORENTER : com.intellij.openapi.application.ApplicationNamesInfo.class
            result = instance;
            if (result == null) {
                instance = result = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            }
            // MONITOREXIT : clazz
        }
        ApplicationNamesInfo applicationNamesInfo = result;
        if (applicationNamesInfo != null) return applicationNamesInfo;
        ApplicationNamesInfo.$$$reportNull$$$0(3);
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo(@NotNull XmlElement rootElement) {
        if (rootElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(4);
        }
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName == null ? this.myFullProductName : this.myFullProductName + ' ' + this.myEditionName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        String s = this.myProductName.toLowerCase(Locale.ENGLISH);
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        String string = this.myMotto;
        if (string == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

