/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance(WriteCommandAction.class);
    private static final String DEFAULT_GROUP_ID = null;
    private final @NlsContexts.Command String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project) {
        return new BuilderImpl(project, new PsiFile[0]);
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(@NotNull PsiFile first, PsiFile ... others) {
        if (first == null) {
            WriteCommandAction.$$$reportNull$$$0(0);
        }
        if (others == null) {
            WriteCommandAction.$$$reportNull$$$0(1);
        }
        return new BuilderImpl(first.getProject(), (PsiFile[])ArrayUtil.prepend((Object)first, (Object[])others));
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(2);
        }
        return new BuilderImpl(project, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(3);
        }
        this(project, WriteCommandAction.getDefaultCommandName(), files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable @NlsContexts.Command String commandName, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(4);
        }
        this(project, commandName, DEFAULT_GROUP_ID, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable @NlsContexts.Command String commandName, @Nullable String groupID, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(5);
        }
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NlsContexts.Command
    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        RunResult result = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result);
        } else {
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> this.performWriteCommandAction(result));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        RunResult runResult = result;
        if (runResult == null) {
            WriteCommandAction.$$$reportNull$$$0(6);
        }
        return runResult;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result) {
        if (result == null) {
            WriteCommandAction.$$$reportNull$$$0(7);
        }
        if (this.myPsiFiles.length > 0 && !FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        Ref resultRef = new Ref(result);
        this.doExecuteCommand(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            ((RunResult)resultRef.get()).run();
            resultRef.set(null);
        }));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected boolean isGlobalUndoAction() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
        if (undoConfirmationPolicy == null) {
            WriteCommandAction.$$$reportNull$$$0(8);
        }
        return undoConfirmationPolicy;
    }

    private void doExecuteCommand(@NotNull Runnable runnable) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(9);
        }
        Runnable wrappedRunnable = () -> {
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.getProject());
            }
            runnable.run();
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), true);
    }

    @TestOnly
    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(10);
        }
        WriteCommandAction.runWriteCommandAction(project, WriteCommandAction.getDefaultCommandName(), DEFAULT_GROUP_ID, runnable, new PsiFile[0]);
    }

    @NlsContexts.Command
    private static String getDefaultCommandName() {
        return CoreBundle.message("command.name.undefined", new Object[0]);
    }

    public static void runWriteCommandAction(Project project, @Nullable @NlsContexts.Command String commandName, @Nullable String groupID, @NotNull Runnable runnable, PsiFile ... files) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(11);
        }
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(12);
        }
        WriteCommandAction.writeCommandAction(project, files).withName(commandName).withGroupId(groupID).run(() -> runnable.run());
    }

    public static <T> T runWriteCommandAction(Project project, @NotNull Computable<T> computable) {
        if (computable == null) {
            WriteCommandAction.$$$reportNull$$$0(13);
        }
        return (T)WriteCommandAction.writeCommandAction(project).compute(() -> computable.compute());
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            WriteCommandAction.$$$reportNull$$$0(14);
        }
        return WriteCommandAction.writeCommandAction(project).compute(computable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "others";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/WriteCommandAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/WriteCommandAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeCommandAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performWriteCommandAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteCommand";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, @NlsContexts.Command String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, @NlsContexts.Command String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<? super T> result) throws Throwable {
            if (result == null) {
                Simple.$$$reportNull$$$0(0);
            }
            this.run();
        }

        protected abstract void run() throws Throwable;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$Simple", "run"));
        }
    }

    private static final class BuilderImpl
    implements Builder {
        private final Project myProject;
        private final PsiFile[] myPsiFiles;
        private @NlsContexts.Command String myCommandName;
        private String myGroupId;
        private UndoConfirmationPolicy myUndoConfirmationPolicy;
        private boolean myGlobalUndoAction;
        private boolean myShouldRecordActionForActiveDocument;

        private BuilderImpl(Project project, PsiFile ... files) {
            if (files == null) {
                BuilderImpl.$$$reportNull$$$0(0);
            }
            this.myCommandName = WriteCommandAction.getDefaultCommandName();
            this.myGroupId = DEFAULT_GROUP_ID;
            this.myShouldRecordActionForActiveDocument = true;
            this.myProject = project;
            this.myPsiFiles = files;
        }

        @Override
        @NotNull
        public Builder withName(@NlsContexts.Command String name) {
            this.myCommandName = name;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(1);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withGlobalUndo() {
            this.myGlobalUndoAction = true;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(2);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean value2) {
            this.myShouldRecordActionForActiveDocument = value2;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(3);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy policy) {
            if (policy == null) {
                BuilderImpl.$$$reportNull$$$0(4);
            }
            if (this.myUndoConfirmationPolicy != null) {
                throw new IllegalStateException("do not call withUndoConfirmationPolicy() several times");
            }
            this.myUndoConfirmationPolicy = policy;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(5);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withGroupId(String groupId) {
            this.myGroupId = groupId;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(6);
            }
            return builderImpl;
        }

        @Override
        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action2) throws E {
            Application application;
            boolean dispatchThread;
            if (action2 == null) {
                BuilderImpl.$$$reportNull$$$0(7);
            }
            if (!(dispatchThread = (application = ApplicationManager.getApplication()).isDispatchThread()) && application.isReadAccessAllowed()) {
                LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
                throw new IllegalStateException();
            }
            AtomicReference thrown = new AtomicReference();
            if (dispatchThread) {
                thrown.set(this.doRunWriteCommandAction(action2));
            } else {
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> thrown.set(this.doRunWriteCommandAction(action2)));
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
            if (thrown.get() != null) {
                throw (Throwable)thrown.get();
            }
        }

        private <E extends Throwable> E doRunWriteCommandAction(@NotNull ThrowableRunnable<E> action2) {
            if (action2 == null) {
                BuilderImpl.$$$reportNull$$$0(8);
            }
            if (this.myPsiFiles.length > 0 && !FileModificationService.getInstance().preparePsiElementsForWrite(this.myPsiFiles)) {
                return null;
            }
            AtomicReference thrown = new AtomicReference();
            Runnable wrappedRunnable = () -> {
                if (this.myGlobalUndoAction) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        action2.run();
                    }
                    catch (Throwable e) {
                        thrown.set(e);
                    }
                });
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, wrappedRunnable, this.myCommandName, (Object)this.myGroupId, (UndoConfirmationPolicy)((Object)ObjectUtils.notNull((Object)((Object)this.myUndoConfirmationPolicy), (Object)((Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION))), this.myShouldRecordActionForActiveDocument);
            return (E)((Throwable)thrown.get());
        }

        @Override
        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> action2) throws E {
            if (action2 == null) {
                BuilderImpl.$$$reportNull$$$0(9);
            }
            AtomicReference result = new AtomicReference();
            this.run(() -> result.set(action2.compute()));
            return (R)result.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/command/WriteCommandAction$BuilderImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/command/WriteCommandAction$BuilderImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGlobalUndo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldRecordActionForActiveDocument";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withUndoConfirmationPolicy";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGroupId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withUndoConfirmationPolicy";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doRunWriteCommandAction";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Builder {
        @Contract(pure=true)
        @NotNull
        public Builder withName(@Nullable @NlsContexts.Command String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGroupId(@Nullable String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGlobalUndo();

        @Contract(pure=true)
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean var1);

        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> var1) throws E;

        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> var1) throws E;
    }
}

