/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkFinder;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    private static final Condition<SdkTypeId> TRUE = sdkTypeId -> true;
    private static final Condition<SdkTypeId> NOT_SIMPLE_JAVA_TYPE = sdkTypeId -> !(sdkTypeId instanceof SimpleJavaSdkType);
    private static final Condition<SdkTypeId> NOT_DEPENDENT_TYPE = sdkTypeId -> sdkTypeId instanceof SdkType && ((SdkType)sdkTypeId).getDependencyType() == null;

    public static SimpleJavaSdkType getInstance() {
        return SdkType.findInstance(SimpleJavaSdkType.class);
    }

    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(@NotNull String jdkName, @NotNull String home) {
        if (jdkName == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(0);
        }
        if (home == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(1);
        }
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message("sdk.java.name", new Object[0]);
        if (string == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(3);
        }
        if (sdkModificator == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData2, @NotNull Element additional) {
        if (additionalData2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(5);
        }
        if (additional == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(6);
        }
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(7);
        }
        return new File(sdk.getHomePath(), "bin").getPath();
    }

    @Override
    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(8);
        }
        return new File(sdk.getHomePath(), "lib/tools.jar").getPath();
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(9);
        }
        return new File(sdk.getHomePath(), "bin/java").getPath();
    }

    @Override
    @Nullable
    public String suggestHomePath() {
        return JdkFinder.getInstance().defaultJavaLocation();
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths() {
        if (!SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists().value((Object)this)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SimpleJavaSdkType.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<String> list = JdkFinder.getInstance().suggestHomePaths();
        if (list == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public boolean isValidSdkHome(@NotNull String path2) {
        if (path2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(12);
        }
        return JdkUtil.checkForJdk(path2);
    }

    @Override
    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        String suggestedName;
        if (sdkHome == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(13);
        }
        return (suggestedName = JdkUtil.suggestJdkName(this.getVersionString(sdkHome))) != null ? suggestedName : (currentSdkName != null ? currentSdkName : "");
    }

    @Override
    public final String getVersionString(String sdkHome) {
        JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo(sdkHome);
        return jdkInfo != null ? JdkVersionDetector.formatVersionString(jdkInfo.version) : null;
    }

    @Override
    @NotNull
    public Comparator<String> versionStringComparator() {
        Comparator comparator = (sdk1, sdk2) -> Comparing.compare((Comparable)JavaVersion.tryParse((String)sdk1), (Comparable)JavaVersion.tryParse((String)sdk2));
        if (comparator == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(14);
        }
        return comparator;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType() {
        Condition<SdkTypeId> condition = NOT_SIMPLE_JAVA_TYPE;
        if (condition == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(15);
        }
        return condition;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType(@Nullable Condition<? super SdkTypeId> condition) {
        if (condition == null) {
            Condition<SdkTypeId> condition2 = NOT_SIMPLE_JAVA_TYPE;
            if (condition2 == null) {
                SimpleJavaSdkType.$$$reportNull$$$0(16);
            }
            return condition2;
        }
        Condition condition3 = sdkTypeId -> NOT_SIMPLE_JAVA_TYPE.value(sdkTypeId) && condition.value(sdkTypeId);
        if (condition3 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(17);
        }
        return condition3;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkTypeIfAlternativeExists() {
        boolean hasNotSimple = Stream.of(SdkType.getAllTypes()).filter(arg_0 -> SimpleJavaSdkType.notSimpleJavaSdkType().value(arg_0)).anyMatch(it -> it instanceof JavaSdkType && it.getDependencyType() == null && !((JavaSdkType)((Object)it)).isDependent());
        if (hasNotSimple) {
            Condition<SdkTypeId> condition = NOT_SIMPLE_JAVA_TYPE;
            if (condition == null) {
                SimpleJavaSdkType.$$$reportNull$$$0(18);
            }
            return condition;
        }
        Condition<SdkTypeId> condition = TRUE;
        if (condition == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(19);
        }
        return condition;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType() {
        Condition<SdkTypeId> preferablyNotSimple = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists();
        Condition condition = sdkType -> sdkType instanceof JavaSdkType && NOT_DEPENDENT_TYPE.value(sdkType) && preferablyNotSimple.value(sdkType);
        if (condition == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(20);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SimpleJavaSdkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SimpleJavaSdkType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "versionStringComparator";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkTypeIfAlternativeExists";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

