/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.messages.AlertMessagesManager;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacMessages;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class Messages {
    public static final int OK = 0;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    @Deprecated
    public static final String OK_BUTTON = "OK";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final String YES_BUTTON = "&Yes";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final String NO_BUTTON = "&No";
    @Deprecated
    public static final String CANCEL_BUTTON = "Cancel";
    private static final Logger LOG = Logger.getInstance(Messages.class);

    @Nls
    public static String getOkButton() {
        return CommonBundle.getOkButtonText();
    }

    public static String getYesButton() {
        return CommonBundle.getYesButtonText();
    }

    public static String getNoButton() {
        return CommonBundle.getNoButtonText();
    }

    @Nls
    public static String getCancelButton() {
        return CommonBundle.getCancelButtonText();
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon2 = UIUtil.getErrorIcon();
        if (icon2 == null) {
            Messages.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon2 = UIUtil.getInformationIcon();
        if (icon2 == null) {
            Messages.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon2 = UIUtil.getWarningIcon();
        if (icon2 == null) {
            Messages.$$$reportNull$$$0(2);
        }
        return icon2;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon2 = UIUtil.getQuestionIcon();
        if (icon2 == null) {
            Messages.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    public static void installHyperlinkSupport(JTextPane messageComponent2) {
        Messages.configureMessagePaneUi(messageComponent2, "<html></html>");
    }

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int lines2) {
        if (comp == null) {
            Messages.$$$reportNull$$$0(4);
        }
        return Messages.wrapToScrollPaneIfNeeded(comp, columns, lines2, 4);
    }

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int maxLines, int lines2) {
        if (comp == null) {
            Messages.$$$reportNull$$$0(5);
        }
        float fontSize = comp.getFont().getSize2D();
        Dimension maxDim = new Dimension((int)(fontSize * (float)columns), (int)(fontSize * (float)maxLines));
        Dimension prefDim = comp.getPreferredSize();
        if (prefDim.width <= maxDim.width && prefDim.height <= maxDim.height) {
            JComponent jComponent = comp;
            if (jComponent == null) {
                Messages.$$$reportNull$$$0(6);
            }
            return jComponent;
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(comp);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        int barWidth = UIUtil.getScrollBarWidth();
        Dimension preferredSize = new Dimension(Math.min(prefDim.width, maxDim.width) + barWidth, Math.min(prefDim.height, maxDim.height) + barWidth);
        if (prefDim.width > maxDim.width) {
            preferredSize.height = Math.max(preferredSize.height, (int)((float)lines2 * fontSize) + barWidth);
        }
        scrollPane.setPreferredSize(preferredSize);
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            Messages.$$$reportNull$$$0(7);
        }
        return jScrollPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent2, @NlsContexts.DialogMessage String message) {
        JTextPane pane = Messages.configureMessagePaneUi(messageComponent2, message, null);
        if ("text/html".equals(pane.getContentType())) {
            pane.addHyperlinkListener((HyperlinkListener)((Object)BrowserHyperlinkListener.INSTANCE));
        }
        JTextPane jTextPane = pane;
        if (jTextPane == null) {
            Messages.$$$reportNull$$$0(8);
        }
        return jTextPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(@NotNull JTextPane messageComponent2, @Nullable @NlsContexts.DialogMessage String message, @Nullable UIUtil.FontSize fontSize) {
        if (messageComponent2 == null) {
            Messages.$$$reportNull$$$0(9);
        }
        UIUtil.FontSize fixedFontSize = fontSize == null ? UIUtil.FontSize.NORMAL : fontSize;
        messageComponent2.setFont(UIUtil.getLabelFont((UIUtil.FontSize)fixedFontSize));
        if (BasicHTML.isHTMLString(message)) {
            messageComponent2.setEditorKit(UIUtil.getHTMLEditorKit());
        }
        messageComponent2.setText(message);
        messageComponent2.setEditable(false);
        if (messageComponent2.getCaret() != null) {
            messageComponent2.setCaretPosition(0);
        }
        messageComponent2.setBackground(UIUtil.getOptionPaneBackground());
        messageComponent2.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent2;
        if (jTextPane == null) {
            Messages.$$$reportNull$$$0(10);
        }
        return jTextPane;
    }

    public static int showDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, @Nullable Icon icon2) {
        if (options == null) {
            Messages.$$$reportNull$$$0(11);
        }
        return Messages.showDialog(project, message, title, options, defaultOptionIndex, icon2, null);
    }

    public static boolean isApplicationInUnitTestOrHeadless() {
        Application application = ApplicationManager.getApplication();
        return application != null && (application.isUnitTestMode() || application.isHeadlessEnvironment());
    }

    @NotNull
    public static Runnable createMessageDialogRemover(@Nullable Project project) {
        Window projectWindow = project == null ? null : WindowManager.getInstance().suggestParentWindow(project);
        Runnable runnable = () -> SwingUtilities.invokeLater(() -> Messages.makeCurrentMessageDialogGoAway(projectWindow == null ? Window.getWindows() : projectWindow.getOwnedWindows()));
        if (runnable == null) {
            Messages.$$$reportNull$$$0(12);
        }
        return runnable;
    }

    private static void makeCurrentMessageDialogGoAway(Window @NotNull [] checkWindows) {
        if (checkWindows == null) {
            Messages.$$$reportNull$$$0(13);
        }
        for (Window w : checkWindows) {
            JButton cancelButton;
            JDialog dialog;
            JDialog jDialog = dialog = w instanceof JDialog ? (JDialog)w : null;
            if (dialog == null || !dialog.isModal() || (cancelButton = (JButton)UIUtil.uiTraverser((Component)dialog.getRootPane()).filter(JButton.class).filter(b -> CommonBundle.getCancelButtonText().equals(b.getText())).first()) == null) continue;
            cancelButton.doClick();
        }
    }

    public static int showDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(14);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(15);
        }
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon2, doNotAskOption, false, null);
    }

    public static int showIdeaMessageDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(16);
        }
        return MessagesService.getInstance().showMessageDialog(project, null, message, title, options, defaultOptionIndex, -1, icon2, doNotAskOption, true, null);
    }

    public static boolean canShowMacSheetPanel() {
        if (!SystemInfoRt.isMac || AlertMessagesManager.isEnabled()) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        return app != null && !app.isUnitTestMode() && !app.isHeadlessEnvironment() && Registry.is((String)"ide.mac.message.dialogs.as.sheets", (boolean)true);
    }

    public static boolean isMacSheetEmulation() {
        return SystemInfoRt.isMac && Registry.is((String)"ide.mac.message.dialogs.as.sheets", (boolean)true) && Registry.is((String)"ide.mac.message.sheets.java.emulation", (boolean)false);
    }

    public static int showDialog(Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable String moreInfo, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(17);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(18);
        }
        return MessagesService.getInstance().showMoreInfoMessageDialog(project, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon2);
    }

    public static int showDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, @Nullable Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(19);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(20);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(21);
        }
        return MessagesService.getInstance().showMessageDialog(null, parent, message, title, options, defaultOptionIndex, -1, icon2, null, false, null);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(22);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(23);
        }
        return MessagesService.getInstance().showMessageDialog(null, null, message, title, options, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, false, null);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(24);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, defaultOptionIndex, icon2, doNotAskOption);
    }

    public static int showDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, int defaultOptionIndex, @Nullable Icon icon2) {
        if (options == null) {
            Messages.$$$reportNull$$$0(25);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, icon2, null);
    }

    public static void showMessageDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(26);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, Messages.getOkButton(), WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{Messages.getOkButton()}, 0, icon2);
    }

    public static void showMessageDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(27);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(28);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, Messages.getOkButton(), SwingUtilities.getWindowAncestor(parent));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(parent, message, title, new String[]{Messages.getOkButton()}, 0, icon2);
    }

    public static void showMessageDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(29);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, Messages.getOkButton(), null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{Messages.getOkButton()}, 0, icon2);
    }

    @Deprecated
    public static int showConfirmationDialog(@NotNull JComponent parent, @NotNull @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String yesText, @NotNull @NlsContexts.Button String noText) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(30);
        }
        if (message == null) {
            Messages.$$$reportNull$$$0(31);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(32);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(33);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(34);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).yesText(yesText)).noText(noText)).ask(parent) ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, @NotNull @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String yesText, @NotNull @NlsContexts.Button String noText, @Nullable Icon icon2) {
        if (message == null) {
            Messages.$$$reportNull$$$0(35);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(36);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(37);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(38);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).yesText(yesText)).noText(noText)).icon(icon2)).ask(project) ? 0 : 1;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String yesText, @NotNull @NlsContexts.Button String noText, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(39);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(40);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(41);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).icon(icon2)).doNotAsk(doNotAskOption)).yesText(yesText)).noText(noText)).ask(project) ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(42);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).icon(icon2)).ask(project) ? 0 : 1;
    }

    @Deprecated
    public static int showYesNoDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(43);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).icon(icon2)).doNotAsk(doNotAskOption)).ask(project) ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(44);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(45);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).icon(icon2)).ask(parent) ? 0 : 1;
    }

    @Deprecated
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nls @NotNull @NlsContexts.Button String yesText, @Nls @NotNull @NlsContexts.Button String noText, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(46);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(47);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(48);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).yesText(yesText)).noText(noText)).icon(icon2)).doNotAsk(doNotAskOption)).guessWindowAndAsk() ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Button String yesText, @NlsContexts.Button String noText, @Nullable Icon icon2) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).yesText(yesText)).noText(noText)).icon(icon2)).guessWindowAndAsk() ? 0 : 1;
    }

    @YesNoResult
    public static int showYesNoDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(49);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(title, message).icon(icon2)).guessWindowAndAsk() ? 0 : 1;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@Nullable Project project, @NotNull @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String okText, @NotNull @NlsContexts.Button String cancelText, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (message == null) {
            Messages.$$$reportNull$$$0(50);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(51);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(52);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(53);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).yesText(okText)).noText(cancelText)).icon(icon2)).doNotAsk(doNotAskOption)).ask(project) ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String okText, @NotNull @NlsContexts.Button String cancelText, @Nullable Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(54);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(55);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(56);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).yesText(okText)).noText(cancelText)).icon(icon2)).ask(project) ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon2) {
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).icon(icon2)).ask(project) ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String okText, @NotNull @NlsContexts.Button String cancelText, Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(57);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(58);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(59);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(60);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).yesText(okText)).noText(cancelText)).icon(icon2)).ask(parent) ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(61);
        }
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).icon(icon2)).ask(parent) ? 0 : 2;
    }

    @Deprecated
    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon2) {
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).icon(icon2)).guessWindowAndAsk() ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Button String okText, @NlsContexts.Button String cancelText, Icon icon2) {
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).yesText(okText)).noText(cancelText)).icon(icon2)).guessWindowAndAsk() ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String okText, @NotNull @NlsContexts.Button String cancelText, Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(62);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(63);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(64);
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel(title, message).yesText(okText)).noText(cancelText)).icon(icon2)).doNotAsk(doNotAskOption)).guessWindowAndAsk() ? 0 : 2;
    }

    public static int showCheckboxOkCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon2) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon2, (PairFunction<? super Integer, ? super JCheckBox, Integer>)((PairFunction)(exitCode, cb) -> exitCode == -1 ? 2 : exitCode + (cb.isSelected() ? 1 : 0)));
    }

    public static int showCheckboxMessageDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NotNull @NlsContexts.Button [] options, @NlsContexts.Checkbox String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon2, @Nullable PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        if (options == null) {
            Messages.$$$reportNull$$$0(65);
        }
        return MessagesService.getInstance().showTwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon2, exitFunc);
    }

    public static int showTwoStepConfirmationDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, Icon icon2) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{Messages.getOkButton()}, checkboxText, true, -1, -1, icon2, null);
    }

    public static void showErrorDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(66);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, Messages.getOkButton(), WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{Messages.getOkButton()}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@Nullable Component component, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(67);
        }
        MessagesService.getInstance().showMessageDialog(null, component, message, title, new String[]{Messages.getOkButton()}, 0, 0, Messages.getErrorIcon(), null, false, null);
    }

    public static void showErrorDialog(@NotNull Component component, @NlsContexts.DialogMessage String message) {
        if (component == null) {
            Messages.$$$reportNull$$$0(68);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(CommonBundle.getErrorTitle(), message, Messages.getOkButton(), SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, CommonBundle.getErrorTitle(), new String[]{Messages.getOkButton()}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(69);
        }
        Messages.showErrorDialog((Component)null, message, title);
    }

    public static void showWarningDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(70);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, Messages.getOkButton(), WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{Messages.getOkButton()}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NotNull Component component, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (component == null) {
            Messages.$$$reportNull$$$0(71);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(72);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, Messages.getOkButton(), SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{Messages.getOkButton()}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(73);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, Messages.getOkButton(), null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{Messages.getOkButton()}, 0, Messages.getWarningIcon());
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String yes, @NotNull @NlsContexts.Button String no, @NotNull @NlsContexts.Button String cancel, @Nullable Icon icon2) {
        if (title == null) {
            Messages.$$$reportNull$$$0(74);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(75);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(76);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(77);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon2)).show(project);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        return ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).icon(icon2)).show(project);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String yes, @NotNull @NlsContexts.Button String no, @NotNull @NlsContexts.Button String cancel, @Nullable Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(78);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(79);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(80);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(81);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(82);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon2)).show(parent);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(83);
        }
        return ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).icon(icon2)).show(parent);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String yes, @NotNull @NlsContexts.Button String no, @NotNull @NlsContexts.Button String cancel, Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(84);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(85);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(86);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(87);
        }
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon2)).doNotAsk(doNotAskOption)).guessWindowAndAsk();
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Button String yes, @NlsContexts.Button String no, @NlsContexts.Button String cancel, Icon icon2) {
        return ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).yesText(yes)).noText(no)).cancelText(cancel).icon(icon2)).guessWindowAndAsk();
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        return ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel(title, message).icon(icon2)).guessWindowAndAsk();
    }

    @Nullable
    public static String showPasswordDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        return Messages.showPasswordDialog(null, message, title, null, null);
    }

    @Nullable
    public static String showPasswordDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        return Messages.showPasswordDialog(project, message, title, icon2, null);
    }

    @Nullable
    public static String showPasswordDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable InputValidator validator2) {
        return MessagesService.getInstance().showPasswordDialog(project, message, title, icon2, validator2);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        return Messages.showInputDialog(project, message, title, icon2, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(88);
        }
        return Messages.showInputDialog(parent, message, title, icon2, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2) {
        return Messages.showInputDialog(message, title, icon2, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2) {
        return MessagesService.getInstance().showInputDialog(project, null, message, title, icon2, initialValue, validator2, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2, @Nullable TextRange selection) {
        return Messages.showInputDialog(project, message, title, icon2, initialValue, validator2, selection, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2, @Nullable TextRange selection, @Nullable @NlsContexts.DetailedDescription String comment) {
        return MessagesService.getInstance().showInputDialog(project, null, message, title, icon2, initialValue, validator2, selection, comment);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(89);
        }
        return MessagesService.getInstance().showInputDialog(null, parent, message, title, icon2, initialValue, validator2, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showInputDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2) {
        return MessagesService.getInstance().showInputDialog(null, null, message, title, icon2, initialValue, validator2, null, null);
    }

    @Nullable
    @NlsSafe
    public static String showMultilineInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable @NonNls String initialValue, @Nullable Icon icon2, @Nullable InputValidator validator2) {
        return MessagesService.getInstance().showMultilineInputDialog(project, message, title, initialValue, icon2, validator2);
    }

    @NotNull
    public static Pair<String, Boolean> showInputDialogWithCheckBox(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2) {
        Pair<String, Boolean> pair = MessagesService.getInstance().showInputDialogWithCheckBox(message, title, checkboxText, checked, checkboxEnabled, icon2, initialValue, validator2);
        if (pair == null) {
            Messages.$$$reportNull$$$0(90);
        }
        return pair;
    }

    @Nullable
    public static String showEditableChooseDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, String[] values, String initialValue, @Nullable InputValidator validator2) {
        return MessagesService.getInstance().showEditableChooseDialog(message, title, icon2, values, initialValue, validator2);
    }

    @Deprecated
    public static int showChooseDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String[] values, String initialValue, @Nullable Icon icon2) {
        return MessagesService.getInstance().showChooseDialog(null, null, message, title, values, initialValue, icon2);
    }

    @Deprecated
    public static int showChooseDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon2, String[] values, String initialValue) {
        return MessagesService.getInstance().showChooseDialog(project, null, message, title, values, initialValue, icon2);
    }

    public static void showInfoMessage(Component component, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(91);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, Messages.getOkButton(), SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(component, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@Nullable Project project, @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(92);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, Messages.getOkButton(), WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(project, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(93);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, Messages.getOkButton(), null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(message, title, Messages.getInformationIcon());
    }

    public static void showTextAreaDialog(JTextField textField, @NlsContexts.DialogTitle String title, @NonNls String dimensionServiceKey, Function<? super String, ? extends List<String>> parser, Function<? super List<String>, String> lineJoiner) {
        MessagesService.getInstance().showTextAreaDialog(textField, title, dimensionServiceKey, parser, lineJoiner);
    }

    public static void showTextAreaDialog(JTextField textField, @NlsContexts.DialogTitle String title, @NonNls String dimensionServiceKey) {
        Messages.showTextAreaDialog(textField, title, dimensionServiceKey, (Function<? super String, ? extends List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<? super List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/Messages";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageComponent";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkWindows";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 49: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 84: 
            case 91: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 19: 
            case 27: 
            case 30: 
            case 44: 
            case 57: 
            case 61: 
            case 78: 
            case 83: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 31: 
            case 35: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 33: 
            case 37: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesText";
                break;
            }
            case 34: 
            case 38: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noText";
                break;
            }
            case 52: 
            case 55: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okText";
                break;
            }
            case 53: 
            case 56: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelText";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 75: 
            case 80: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yes";
                break;
            }
            case 76: 
            case 81: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "no";
                break;
            }
            case 77: 
            case 82: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/Messages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToScrollPaneIfNeeded";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "configureMessagePaneUi";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessageDialogRemover";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "showInputDialogWithCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapToScrollPaneIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureMessagePaneUi";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeCurrentMessageDialogGoAway";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showIdeaMessageDialog";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showMessageDialog";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showConfirmationDialog";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "showOkCancelDialog";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "showCheckboxMessageDialog";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "showWarningDialog";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoCancelDialog";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "showInfoMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MultilineInputDialog
    extends InputDialog {
        public MultilineInputDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2, String @NotNull @NlsContexts.Button [] options, int defaultOption) {
            if (options == null) {
                MultilineInputDialog.$$$reportNull$$$0(0);
            }
            super(project, message, title, icon2, initialValue, validator2, options, defaultOption);
        }

        @Override
        protected JTextComponent createTextFieldComponent() {
            return new JTextArea(7, 50);
        }

        @Override
        protected JComponent createScrollableTextComponent() {
            return new JBScrollPane(this.myField);
        }

        @Override
        protected JComponent createNorthPanel() {
            return null;
        }

        @Override
        protected JComponent createCenterPanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "Center");
            return messagePanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MultilineInputDialog", "<init>"));
        }
    }

    public static class InputDialog
    extends MessageDialog {
        public static final int INPUT_DIALOG_COLUMNS = 30;
        protected JTextComponent myField;
        private final InputValidator myValidator;
        private final @NlsContexts.DetailedDescription String myComment;

        public InputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2, String @NotNull @NlsContexts.Button [] options, int defaultOption, @Nullable @NlsContexts.DetailedDescription String comment) {
            if (options == null) {
                InputDialog.$$$reportNull$$$0(0);
            }
            super(project, true);
            this.myComment = comment;
            this.myValidator = validator2;
            this._init(title, message, options, defaultOption, -1, icon2, null, null);
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2, String @NotNull @NlsContexts.Button [] options, int defaultOption) {
            if (options == null) {
                InputDialog.$$$reportNull$$$0(1);
            }
            this(project, message, title, icon2, initialValue, validator2, options, defaultOption, null);
        }

        public InputDialog(@Nullable Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable @NonNls String initialValue, @Nullable InputValidator validator2) {
            this(project, message, title, icon2, initialValue, validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0);
        }

        public InputDialog(@NotNull Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable String initialValue, @Nullable InputValidator validator2) {
            if (parent == null) {
                InputDialog.$$$reportNull$$$0(2);
            }
            super(null, parent, message, title, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, -1, 0, icon2, null, true);
            this.myValidator = validator2;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @Nullable Icon icon2, @Nullable String initialValue, @Nullable InputValidator validator2) {
            super(null, null, message, title, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0, -1, icon2, null, true);
            this.myValidator = validator2;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        private void enableOkAction() {
            this.getOKAction().setEnabled(this.myValidator == null || this.myValidator.checkInput(this.myField.getText().trim()));
        }

        @Override
        protected Action @NotNull [] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == 0) {
                    actions[0] = this.getOKAction();
                    actions[0].putValue("DefaultAction", Boolean.TRUE);
                    this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(@NotNull DocumentEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            String text2 = myField.getText().trim();
                            actions[exitCode].setEnabled(myValidator == null || myValidator.checkInput(text2));
                            if (myValidator instanceof InputValidatorEx) {
                                this.setErrorText(((InputValidatorEx)myValidator).getErrorText(text2), myField);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/ui/Messages$InputDialog$1", "textChanged"));
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.close(exitCode);
                    }
                };
            }
            if (actions == null) {
                InputDialog.$$$reportNull$$$0(3);
            }
            return actions;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myField.getText().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                this.close(0);
            }
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel2 = this.createIconPanel();
            JPanel messagePanel = this.createMessagePanel();
            panel2.add((Component)messagePanel, "Center");
            if (this.myComment != null) {
                return UI.PanelFactory.panel(panel2).withComment(this.myComment).createPanel();
            }
            return panel2;
        }

        @Override
        @NotNull
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "South");
            JPanel jPanel = messagePanel;
            if (jPanel == null) {
                InputDialog.$$$reportNull$$$0(4);
            }
            return jPanel;
        }

        protected JComponent createScrollableTextComponent() {
            return this.myField;
        }

        protected JComponent createTextComponent() {
            JComponent textComponent;
            if (BasicHTML.isHTMLString(this.myMessage)) {
                textComponent = this.createMessageComponent(this.myMessage);
            } else {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setUI(new MultiLineLabelUI());
                textComponent = textLabel;
            }
            textComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 20));
            return textComponent;
        }

        public JTextComponent getTextField() {
            return this.myField;
        }

        protected JTextComponent createTextFieldComponent() {
            JTextField field = new JTextField(30);
            field.setMargin((Insets)JBInsets.create((int)0, (int)5));
            return field;
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        @NlsSafe
        public String getInputString() {
            return this.getExitCode() == 0 ? this.myField.getText().trim() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/Messages$InputDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/Messages$InputDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessagePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static @interface YesNoCancelResult {
    }

    public static @interface OkCancelResult {
    }

    public static @interface YesNoResult {
    }
}

