/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.FilterDescendantVirtualFileConvertible;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.StartedActivated;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.VcsSynchronousProgressWrapper;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcs
extends StartedActivated {
    @NonNls
    protected static final String ourIntegerPattern = "\\d+";
    @NotNull
    protected final Project myProject;
    private final String myName;
    private final VcsKey myKey;
    private CheckinEnvironment myCheckinEnvironment;
    private UpdateEnvironment myUpdateEnvironment;
    private RollbackEnvironment myRollbackEnvironment;

    public AbstractVcs(@NotNull Project project, @NonNls String name) {
        if (project == null) {
            AbstractVcs.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myName = name;
        this.myKey = new VcsKey(this.myName);
    }

    @Override
    protected void start() throws VcsException {
    }

    @Override
    protected void shutdown() {
    }

    @Override
    protected void activate() {
    }

    @Override
    protected void deactivate() {
    }

    @NonNls
    public final String getName() {
        return this.myName;
    }

    @Nls
    @NotNull
    public abstract String getDisplayName();

    @Nls
    @NotNull
    public String getShortName() {
        String string = this.getDisplayName();
        if (string == null) {
            AbstractVcs.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getShortNameWithMnemonic() {
        String string = VcsBundle.message("vcs.generic.name.with.mnemonic", new Object[0]);
        if (string == null) {
            AbstractVcs.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isWithCustomMenu() {
        return false;
    }

    public boolean isWithCustomLocalChanges() {
        return false;
    }

    @NlsActions.ActionText
    @Nullable
    public String getCompareWithTheSameVersionActionName() {
        return null;
    }

    public Configurable getConfigurable() {
        return null;
    }

    @Nullable
    public TransactionProvider getTransactionProvider() {
        return null;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return null;
    }

    public final VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance(this.myProject);
    }

    @Nullable
    public EditFileProvider getEditFileProvider() {
        return null;
    }

    public boolean markExternalChangesAsUpToDate() {
        return false;
    }

    @Nullable
    protected CheckinEnvironment createCheckinEnvironment() {
        return null;
    }

    @Nullable
    public CheckinEnvironment getCheckinEnvironment() {
        return this.myCheckinEnvironment;
    }

    @Nullable
    protected RollbackEnvironment createRollbackEnvironment() {
        return null;
    }

    @Nullable
    public RollbackEnvironment getRollbackEnvironment() {
        return this.myRollbackEnvironment;
    }

    @Nullable
    public VcsHistoryProvider getVcsHistoryProvider() {
        return null;
    }

    @Nullable
    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return null;
    }

    public String getMenuItemText() {
        return this.getDisplayName();
    }

    @Nullable
    protected UpdateEnvironment createUpdateEnvironment() {
        return null;
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    @Deprecated
    public boolean fileIsUnderVcs(FilePath filePath2) {
        return true;
    }

    public boolean fileExistsInVcs(FilePath path2) {
        VirtualFile virtualFile2 = path2.getVirtualFile();
        if (virtualFile2 != null) {
            FileStatus fileStatus = FileStatusManager.getInstance(this.myProject).getStatus(virtualFile2);
            return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
        }
        return true;
    }

    @RequiresEdt
    public void enableIntegration() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        if (vcsManager != null) {
            vcsManager.setDirectoryMappings(Collections.singletonList(VcsDirectoryMapping.createDefault(this.getName())));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public ThreeState mayRemoveChangeList(@NotNull LocalChangeList localChangeList, boolean bl) {
        void list;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (list == null) {
            AbstractVcs.$$$reportNull$$$0(3);
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            AbstractVcs.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    public boolean isTrackingUnchangedContent() {
        return false;
    }

    public static boolean fileInVcsByFileStatus(@NotNull Project project, @NotNull FilePath path2) {
        VirtualFile file;
        if (project == null) {
            AbstractVcs.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            AbstractVcs.$$$reportNull$$$0(6);
        }
        return (file = path2.getVirtualFile()) == null || AbstractVcs.fileInVcsByFileStatus(project, file);
    }

    public static boolean fileInVcsByFileStatus(@NotNull Project project, @NotNull VirtualFile file) {
        FileStatus status;
        if (project == null) {
            AbstractVcs.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AbstractVcs.$$$reportNull$$$0(8);
        }
        return (status = FileStatusManager.getInstance(project).getStatus(file)) != FileStatus.UNKNOWN && status != FileStatus.ADDED && status != FileStatus.IGNORED;
    }

    @Nullable
    public UpdateEnvironment getStatusEnvironment() {
        return null;
    }

    @Nullable
    public AnnotationProvider getAnnotationProvider() {
        return null;
    }

    @Nullable
    public DiffProvider getDiffProvider() {
        return null;
    }

    public void loadSettings() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        if (this.getUpdateEnvironment() != null) {
            vcsManager.getStandardOption(VcsConfiguration.StandardOption.UPDATE, this);
        }
        if (this.getStatusEnvironment() != null) {
            vcsManager.getStandardOption(VcsConfiguration.StandardOption.STATUS, this);
        }
    }

    public FileStatus[] getProvidedStatuses() {
        return null;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return null;
    }

    @Nullable
    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    @Nullable
    public CommittedChangesProvider<? extends CommittedChangeList, ?> getCommittedChangesProvider() {
        return null;
    }

    @Nullable
    public final CachingCommittedChangesProvider<? extends CommittedChangeList, ?> getCachingCommittedChangesProvider() {
        CommittedChangesProvider<? extends CommittedChangeList, ?> provider = this.getCommittedChangesProvider();
        if (provider instanceof CachingCommittedChangesProvider) {
            return (CachingCommittedChangesProvider)provider;
        }
        return null;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString, FilePath path2) throws VcsException {
        return this.parseRevisionNumber(revisionNumberString);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) throws VcsException {
        return null;
    }

    @NonNls
    @Nullable
    public String getRevisionPattern() {
        return null;
    }

    @Deprecated
    public boolean isVersionedDirectory(VirtualFile dir) {
        return false;
    }

    @Nullable
    public UnnamedConfigurable getRootConfigurable(VcsDirectoryMapping mapping) {
        return null;
    }

    @Nullable
    public VcsRootSettings createEmptyVcsRootSettings() {
        return null;
    }

    @Nullable
    public RootsConvertor getCustomConvertor() {
        return null;
    }

    public boolean needsLegacyDefaultMappings() {
        if (this.getCustomConvertor() != null) {
            return true;
        }
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!checker.getSupportedVcs().equals(this.getKeyInstanceMethod())) continue;
            return false;
        }
        VcsDescriptor descriptor = AllVcsesI.getInstance(this.myProject).getDescriptor(this.myName);
        return descriptor == null || !descriptor.hasVcsDirPattern();
    }

    @Nullable
    public MergeProvider getMergeProvider() {
        return null;
    }

    public boolean allowsNestedRoots() {
        return false;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<? super S, ? extends VirtualFile> convertor) {
        if (in == null) {
            AbstractVcs.$$$reportNull$$$0(9);
        }
        if (convertor == null) {
            AbstractVcs.$$$reportNull$$$0(10);
        }
        if (!this.allowsNestedRoots()) {
            new FilterDescendantVirtualFileConvertible<S>(convertor, FilePathComparator.getInstance()).doFilter(in);
        }
        List<S> list = in;
        if (list == null) {
            AbstractVcs.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public VcsExceptionsHotFixer getVcsExceptionsHotFixer() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractVcs.$$$reportNull$$$0(12);
        }
        return project;
    }

    protected static VcsKey createKey(@NonNls String name) {
        return new VcsKey(name);
    }

    public final VcsKey getKeyInstanceMethod() {
        return this.myKey;
    }

    public VcsType getType() {
        return VcsType.centralized;
    }

    @Nullable
    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return null;
    }

    @Nullable
    public final VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingChangesProvider() {
        return VcsType.centralized.equals((Object)this.getType()) ? null : this.getOutgoingProviderImpl();
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_LATEST_REVISION;
    }

    public boolean areDirectoriesVersionedItems() {
        return false;
    }

    @Nullable
    protected TreeDiffProvider getTreeDiffProviderImpl() {
        return null;
    }

    @Nullable
    public TreeDiffProvider getTreeDiffProvider() {
        RemoteDifferenceStrategy strategy = this.getRemoteDifferenceStrategy();
        return RemoteDifferenceStrategy.ASK_LATEST_REVISION.equals((Object)strategy) ? null : this.getTreeDiffProviderImpl();
    }

    public List<CommitExecutor> getCommitExecutors() {
        return Collections.emptyList();
    }

    public boolean isVcsBackgroundOperationsAllowed(VirtualFile root) {
        return true;
    }

    public boolean allowsRemoteCalls(@NotNull VirtualFile file) {
        if (file == null) {
            AbstractVcs.$$$reportNull$$$0(13);
        }
        return true;
    }

    public void setCheckinEnvironment(CheckinEnvironment checkinEnvironment) {
        if (this.myCheckinEnvironment != null) {
            throw new IllegalStateException("Attempt to redefine checkin environment");
        }
        this.myCheckinEnvironment = checkinEnvironment;
    }

    public void setUpdateEnvironment(UpdateEnvironment updateEnvironment) {
        if (this.myUpdateEnvironment != null) {
            throw new IllegalStateException("Attempt to redefine update environment");
        }
        this.myUpdateEnvironment = updateEnvironment;
    }

    public void setRollbackEnvironment(RollbackEnvironment rollbackEnvironment) {
        if (this.myRollbackEnvironment != null) {
            throw new IllegalStateException("Attempt to redefine rollback environment");
        }
        this.myRollbackEnvironment = rollbackEnvironment;
    }

    public void setupEnvironments() {
        this.setCheckinEnvironment(this.createCheckinEnvironment());
        this.setUpdateEnvironment(this.createUpdateEnvironment());
        this.setRollbackEnvironment(this.createRollbackEnvironment());
    }

    @Nullable
    public CommittedChangeList loadRevisions(VirtualFile vf, @NotNull VcsRevisionNumber number) {
        if (number == null) {
            AbstractVcs.$$$reportNull$$$0(14);
        }
        return (CommittedChangeList)VcsSynchronousProgressWrapper.compute(() -> {
            CommittedChangesProvider<CommittedChangeList, ?> provider = this.getCommittedChangesProvider();
            Pair<? extends CommittedChangeList, FilePath> pair = provider == null ? null : provider.getOneList(vf, number);
            return pair == null ? null : (CommittedChangeList)pair.getFirst();
        }, this.getProject(), VcsBundle.message("title.load.revision.contents", new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractVcs that = (AbstractVcs)o;
        return this.myKey.equals(that.myKey);
    }

    public int hashCode() {
        return this.myKey.hashCode();
    }

    public boolean fileListenerIsSynchronous() {
        return true;
    }

    public boolean arePartialChangelistsSupported() {
        return false;
    }

    public CheckoutProvider getCheckoutProvider() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean needsCaseSensitiveDirtyScope() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/AbstractVcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/AbstractVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameWithMnemonic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mayRemoveChangeList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayRemoveChangeList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileInVcsByFileStatus";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueRoots";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "allowsRemoteCalls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RootsConvertor {
        @NotNull
        public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> var1);
    }
}

