/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.PackageEntry;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class PackageEntryTable
implements JDOMExternalizable,
Cloneable {
    private final List<PackageEntry> myEntries = new ArrayList<PackageEntry>();

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageEntryTable)) {
            return false;
        }
        PackageEntryTable other = (PackageEntryTable)obj;
        if (other.myEntries.size() != this.myEntries.size()) {
            return false;
        }
        for (int i = 0; i < this.myEntries.size(); ++i) {
            PackageEntry otherentry;
            PackageEntry entry = this.myEntries.get(i);
            if (Comparing.equal((Object)entry, (Object)(otherentry = other.myEntries.get(i)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.myEntries.isEmpty() && this.myEntries.get(0) != null) {
            return this.myEntries.get(0).hashCode();
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        PackageEntryTable clon = new PackageEntryTable();
        clon.copyFrom(this);
        return clon;
    }

    public void copyFrom(PackageEntryTable packageTable) {
        this.myEntries.clear();
        this.myEntries.addAll(packageTable.myEntries);
    }

    public PackageEntry[] getEntries() {
        return this.myEntries.toArray(new PackageEntry[0]);
    }

    public void insertEntryAt(PackageEntry entry, int i) {
        this.myEntries.add(i, entry);
    }

    public void removeEntryAt(int i) {
        this.myEntries.remove(i);
    }

    public PackageEntry getEntryAt(int i) {
        return this.myEntries.get(i);
    }

    public int getEntryCount() {
        return this.myEntries.size();
    }

    public void setEntryAt(PackageEntry entry, int i) {
        this.myEntries.set(i, entry);
    }

    public boolean contains(String packageName) {
        for (PackageEntry entry : this.myEntries) {
            if (!packageName.startsWith(entry.getPackageName())) continue;
            if (packageName.length() == entry.getPackageName().length()) {
                return true;
            }
            if (!entry.isWithSubpackages() || packageName.charAt(entry.getPackageName().length()) != '.') continue;
            return true;
        }
        return false;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myEntries.clear();
        List children2 = element.getChildren();
        for (Element e : children2) {
            @NonNls String name = e.getName();
            if ("package".equals(name)) {
                String packageName = e.getAttributeValue("name");
                boolean isStatic = Boolean.parseBoolean(e.getAttributeValue("static"));
                boolean withSubpackages = Boolean.parseBoolean(e.getAttributeValue("withSubpackages"));
                if (packageName == null) {
                    throw new InvalidDataException();
                }
                PackageEntry entry = packageName.isEmpty() ? (isStatic ? PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY : PackageEntry.ALL_OTHER_IMPORTS_ENTRY) : new PackageEntry(isStatic, packageName, withSubpackages);
                this.myEntries.add(entry);
                continue;
            }
            if (!"emptyLine".equals(name)) continue;
            this.myEntries.add(PackageEntry.BLANK_LINE_ENTRY);
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        for (PackageEntry entry : this.myEntries) {
            Element element;
            if (entry == PackageEntry.BLANK_LINE_ENTRY) {
                element = new Element("emptyLine");
                parentNode.addContent(element);
                continue;
            }
            element = new Element("package");
            parentNode.addContent(element);
            String packageName = entry.getPackageName();
            element.setAttribute("name", entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY ? "" : packageName);
            element.setAttribute("withSubpackages", entry.isWithSubpackages() ? "true" : "false");
            element.setAttribute("static", entry.isStatic() ? "true" : "false");
        }
    }

    public void removeEmptyPackages() {
        for (int i = this.myEntries.size() - 1; i >= 0; --i) {
            PackageEntry entry = this.myEntries.get(i);
            if (!StringUtil.isEmptyOrSpaces((String)entry.getPackageName())) continue;
            this.removeEntryAt(i);
        }
    }

    public void addEntry(PackageEntry entry) {
        this.myEntries.add(entry);
    }
}

