/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementStandardSettingsManager {
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWidths;
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWeights;
    @NotNull
    private final Comparator<ArrangementSettingsToken> myComparator;
    @NotNull
    private final ArrangementStandardSettingsAware myDelegate;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final Collection<Set<ArrangementSettingsToken>> myMutexes;
    @Nullable
    private final StdArrangementSettings myDefaultSettings;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myGroupingTokens;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myMatchingTokens;
    @NotNull
    private final Collection<StdArrangementRuleAliasToken> myRuleAliases;
    @NotNull
    private final Set<ArrangementSettingsToken> myRuleAliasMutex;
    @Nullable
    private CompositeArrangementSettingsToken myRuleAliasToken;

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider) {
        if (delegate == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(1);
        }
        this(delegate, colorsProvider, ContainerUtil.emptyList());
    }

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider, @NotNull Collection<StdArrangementRuleAliasToken> aliases) {
        if (delegate == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(2);
        }
        if (colorsProvider == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(3);
        }
        if (aliases == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(4);
        }
        this.myWidths = new TObjectIntHashMap();
        this.myWeights = new TObjectIntHashMap();
        this.myComparator = (t1, t2) -> {
            if (this.myWeights.containsKey(t1)) {
                if (this.myWeights.containsKey(t2)) {
                    return this.myWeights.get(t1) - this.myWeights.get(t2);
                }
                return -1;
            }
            if (this.myWeights.containsKey(t2)) {
                return 1;
            }
            return t1.compareTo((ArrangementSettingsToken)t2);
        };
        this.myDelegate = delegate;
        this.myColorsProvider = colorsProvider;
        this.myMutexes = delegate.getMutexes();
        this.myDefaultSettings = delegate.getDefaultSettings();
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        this.myGroupingTokens = delegate.getSupportedGroupingTokens();
        if (this.myGroupingTokens != null) {
            this.parseWidths(this.myGroupingTokens, renderer);
            this.buildWeights(this.myGroupingTokens);
        }
        this.myMatchingTokens = delegate.getSupportedMatchingTokens();
        if (this.myMatchingTokens != null) {
            this.parseWidths(this.myMatchingTokens, renderer);
            this.buildWeights(this.myMatchingTokens);
        }
        HashSet<ArrangementSettingsToken> aliasTokens = new HashSet<ArrangementSettingsToken>();
        aliasTokens.addAll(aliases);
        this.myRuleAliases = aliases;
        this.myRuleAliasMutex = aliasTokens;
        if (!this.myRuleAliases.isEmpty()) {
            this.myRuleAliasToken = new CompositeArrangementSettingsToken(StdArrangementTokens.General.ALIAS, aliasTokens);
        }
    }

    @NotNull
    public Collection<StdArrangementRuleAliasToken> getRuleAliases() {
        Collection<StdArrangementRuleAliasToken> collection = this.myRuleAliases;
        if (collection == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public ArrangementStandardSettingsAware getDelegate() {
        ArrangementStandardSettingsAware arrangementStandardSettingsAware = this.myDelegate;
        if (arrangementStandardSettingsAware == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(6);
        }
        return arrangementStandardSettingsAware;
    }

    private void parseWidths(@NotNull Collection<? extends CompositeArrangementSettingsToken> compositeTokens, @NotNull SimpleColoredComponent renderer) {
        if (compositeTokens == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(7);
        }
        if (renderer == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(8);
        }
        int width = 0;
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            width = Math.max(width, this.parseWidth(compositeArrangementSettingsToken.getToken(), renderer));
        }
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            this.myWidths.put((Object)compositeArrangementSettingsToken.getToken(), width);
            this.parseWidths(compositeArrangementSettingsToken.getChildren(), renderer);
        }
    }

    private void buildWeights(@NotNull Collection<? extends CompositeArrangementSettingsToken> compositeTokens) {
        if (compositeTokens == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(9);
        }
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            this.myWeights.put((Object)compositeArrangementSettingsToken.getToken(), this.myWeights.size());
            this.buildWeights(compositeArrangementSettingsToken.getChildren());
        }
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    public boolean isSectionRulesSupported() {
        return this.myDelegate instanceof ArrangementSectionRuleAwareSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return this.myGroupingTokens;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        if (this.myMatchingTokens == null || this.myRuleAliasToken == null) {
            return this.myMatchingTokens;
        }
        ArrayList<CompositeArrangementSettingsToken> allTokens = new ArrayList<CompositeArrangementSettingsToken>(this.myMatchingTokens);
        allTokens.add(this.myRuleAliasToken);
        return allTokens;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(10);
        }
        if (this.myRuleAliasMutex.contains(token)) {
            return true;
        }
        return this.myDelegate.isEnabled(token, current);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        ArrangementEntryMatcher matcher;
        if (condition == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(11);
        }
        if ((matcher = ArrangementUtil.buildMatcher(condition)) == null) {
            matcher = this.myDelegate.buildMatcher(condition);
        }
        ArrangementEntryMatcher arrangementEntryMatcher = matcher;
        if (arrangementEntryMatcher == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(12);
        }
        return arrangementEntryMatcher;
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        if (this.myRuleAliasMutex.isEmpty()) {
            Collection<Set<ArrangementSettingsToken>> collection = this.myMutexes;
            if (collection == null) {
                ArrangementStandardSettingsManager.$$$reportNull$$$0(13);
            }
            return collection;
        }
        ArrayList<Set<ArrangementSettingsToken>> allMutexes = new ArrayList<Set<ArrangementSettingsToken>>(this.myMutexes);
        allMutexes.add(this.myRuleAliasMutex);
        ArrayList<Set<ArrangementSettingsToken>> arrayList = allMutexes;
        if (arrayList == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public int getWidth(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(15);
        }
        if (this.myWidths.containsKey((Object)token)) {
            return this.myWidths.get((Object)token);
        }
        return this.parseWidth(token, new SimpleColoredComponent());
    }

    private int parseWidth(@NotNull ArrangementSettingsToken token, @NotNull SimpleColoredComponent renderer) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(16);
        }
        if (renderer == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(17);
        }
        renderer.clear();
        String value2 = ArrangementStandardSettingsManager.getPresentationValue(token);
        renderer.append(value2, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.myColorsProvider.getTextAttributes(token, true)));
        int result = renderer.getPreferredSize().width;
        renderer.clear();
        renderer.append(value2, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.myColorsProvider.getTextAttributes(token, false)));
        return Math.max(result, renderer.getPreferredSize().width);
    }

    @NotNull
    @Nls
    private static String getPresentationValue(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(18);
        }
        if (token instanceof InvertibleArrangementSettingsToken) {
            String string = ((InvertibleArrangementSettingsToken)((Object)token)).getInvertedRepresentationValue();
            if (string == null) {
                ArrangementStandardSettingsManager.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = token.getRepresentationValue();
        if (string == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(20);
        }
        return string;
    }

    public List<ArrangementSettingsToken> sort(@NotNull Collection<? extends ArrangementSettingsToken> tokens) {
        if (tokens == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(21);
        }
        ArrayList<ArrangementSettingsToken> result = new ArrayList<ArrangementSettingsToken>(tokens);
        result.sort(this.myComparator);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeTokens";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuleAliases";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseWidths";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildWeights";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWidth";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

