/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/psi/util/PsiEditorUtilBase;", "Lcom/intellij/psi/util/PsiEditorUtil;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findEditorByPsiElement", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang"})
public final class PsiEditorUtilBase
implements PsiEditorUtil {
    private static final Logger LOG;
    @NotNull
    public static final PsiEditorUtilBase INSTANCE;

    @Override
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"PsiUtilCore.getVirtualFile(element) ?: return null");
        VirtualFile virtualFile3 = virtualFile2;
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"psiFile");
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
        Project project2 = project;
        if (virtualFile3.isInLocalFileSystem() || virtualFile3.getFileSystem() instanceof NonPhysicalFileSystem) {
            FileEditor[] editors;
            FileEditor[] fileEditorManager;
            FileEditor[] fileEditorArray = fileEditorManager = FileEditorManager.getInstance(project2);
            if (fileEditorManager == null || (fileEditorArray = fileEditorArray.getEditors(virtualFile3)) == null) {
                fileEditorArray = new FileEditor[]{};
            }
            for (FileEditor editor2 : editors = fileEditorArray) {
                if (!(editor2 instanceof TextEditor)) continue;
                return ((TextEditor)editor2).getEditor();
            }
        }
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
        Promise<DataContext> promise = dataManager.getDataContextFromFocusAsync();
        Intrinsics.checkNotNullExpressionValue(promise, (String)"DataManager.getInstance(\u2026dataContextFromFocusAsync");
        Promise<DataContext> asyncResult = promise;
        if (asyncResult.isSucceeded()) {
            Document cachedDocument;
            Editor editor = null;
            try {
                FileEditor editor2;
                editor2 = asyncResult.blockingGet(-1);
                int n = 0;
                boolean bl = false;
                bl = false;
                int n2 = 0;
                if (editor2 == null) {
                    boolean bl2 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                editor = (Editor)CommonDataKeys.EDITOR.getData((DataContext)editor2);
            }
            catch (TimeoutException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            if (editor != null && (cachedDocument = PsiDocumentManager.getInstance(project2).getCachedDocument(psiFile)) == editor.getDocument()) {
                return editor;
            }
        }
        return null;
    }

    private PsiEditorUtilBase() {
    }

    static {
        PsiEditorUtilBase psiEditorUtilBase;
        INSTANCE = psiEditorUtilBase = new PsiEditorUtilBase();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PsiEditorUtilBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

