/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task {
    public static final Task[] EMPTY_ARRAY = new Task[0];

    @NotNull
    public abstract String getId();

    @NlsSafe
    @NotNull
    public String getPresentableId() {
        String string = this.getId();
        if (string == null) {
            Task.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public abstract String getSummary();

    @Nls
    @Nullable
    public abstract String getDescription();

    public abstract Comment @NotNull [] getComments();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract TaskType getType();

    @Nullable
    public abstract Date getUpdated();

    @Nullable
    public abstract Date getCreated();

    public abstract boolean isClosed();

    @Nullable
    public String getCustomIcon() {
        return null;
    }

    public abstract boolean isIssue();

    @Nullable
    public abstract String getIssueUrl();

    @Nullable
    public TaskRepository getRepository() {
        return null;
    }

    @Nullable
    public TaskState getState() {
        return null;
    }

    @NlsSafe
    public final String toString() {
        Object text2 = this.isIssue() ? this.getPresentableId() + ": " + this.getSummary() : this.getSummary();
        return StringUtil.first((String)text2, (int)60, (boolean)true);
    }

    @NlsContexts.Label
    public String getPresentableName() {
        return this.toString();
    }

    public final boolean equals(Object obj) {
        return obj instanceof Task && ((Task)obj).getId().equals(this.getId());
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    @NotNull
    public String getNumber() {
        return Task.extractNumberFromId(this.getId());
    }

    @NotNull
    protected static String extractNumberFromId(@NotNull String id) {
        int i;
        if (id == null) {
            Task.$$$reportNull$$$0(1);
        }
        String string = (i = id.lastIndexOf(45)) > 0 ? id.substring(i + 1) : id;
        if (string == null) {
            Task.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getProject() {
        return Task.extractProjectFromId(this.getId());
    }

    @Nullable
    protected static String extractProjectFromId(@NotNull String id) {
        int i;
        if (id == null) {
            Task.$$$reportNull$$$0(3);
        }
        return (i = id.lastIndexOf(45)) > 0 ? id.substring(0, i) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/Task";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableId";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/Task";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNumberFromId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractNumberFromId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractProjectFromId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

