/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBInsets;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class GroupHeaderSeparator
extends SeparatorWithText {
    private boolean myHideLine;
    private final Insets myLabelInsets;

    public GroupHeaderSeparator(Insets insets) {
        this.myLabelInsets = insets;
    }

    public void setHideLine(boolean hideLine) {
        this.myHideLine = hideLine;
    }

    @Override
    protected Dimension getPreferredElementSize() {
        Dimension size = new Dimension(Math.max(this.myPrefWidth, 0), 0);
        if (!StringUtil.isEmpty((String)this.getCaption())) {
            size = this.getLabelSize();
            size.height += this.myLabelInsets.top + this.myLabelInsets.bottom;
        }
        if (!this.myHideLine) {
            size.height += GroupHeaderSeparator.getVgap() + 1;
        }
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String caption;
        g.setColor(this.getForeground());
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        if (!this.myHideLine) {
            GroupHeaderSeparator.paintLine(g, bounds);
            bounds.y += GroupHeaderSeparator.getVgap() + 1;
        }
        if ((caption = this.getCaption()) != null) {
            bounds.x += this.myLabelInsets.left;
            bounds.width -= this.myLabelInsets.left + this.myLabelInsets.right;
            bounds.y += this.myLabelInsets.top;
            bounds.height -= this.myLabelInsets.top + this.myLabelInsets.bottom;
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            FontMetrics fm = g.getFontMetrics();
            String label = SwingUtilities.layoutCompoundLabel(fm, caption, null, 0, 2, 0, 2, bounds, iconR, textR, 0);
            UISettings.setupAntialiasing(g);
            g.setColor(this.getTextForeground());
            g.drawString(label, textR.x, textR.y + fm.getAscent());
        }
    }

    private static void paintLine(Graphics g, Rectangle bounds) {
        int x = bounds.x + GroupHeaderSeparator.getHgap();
        int width = bounds.width - GroupHeaderSeparator.getHgap() * 2;
        int y = bounds.y + GroupHeaderSeparator.getVgap();
        RectanglePainter.FILL.paint((Graphics2D)g, x, y, width, 1, null);
    }
}

