/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSAddBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new AddBracesPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            return JavaScriptBundle.message((String)"js.add.braces.to.arrow.function", (Object[])new Object[0]);
        }
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = JSAddBracesIntention.quote(element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD);
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = JSAddBracesIntention.quote(firstChild.getText());
        }
        return JSIntentionBundle.message("braces.add-braces.display-name", keyword);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("braces.add-braces.family-name", new Object[0]);
        if (string == null) {
            JSAddBracesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String quote(@NotNull String s) {
        if (s == null) {
            JSAddBracesIntention.$$$reportNull$$$0(1);
        }
        return "'" + s + "'";
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(2);
        }
        if (element instanceof JSFunctionExpression && JSAddBracesIntention.isShorthandArrowFunction(element)) {
            JSRefactoringUtil.addBracesToShorthandArrowFunction((JSFunctionExpression)((JSFunctionExpression)element));
            return;
        }
        JSRefactoringUtil.addBracesToStatement((PsiElement)element);
    }

    private static boolean isShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(3);
        }
        return element instanceof JSFunctionExpression && ((JSFunctionExpression)element).isShorthandArrowFunction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandArrowFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddBracesPredicate
    implements JSElementPredicate {
        private AddBracesPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                AddBracesPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSStatement)) {
                return JSAddBracesIntention.isShorthandArrowFunction(element);
            }
            if (element instanceof JSBlockStatement) {
                return false;
            }
            PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof JSElement)) {
                return false;
            }
            JSElement parent = (JSElement)parentElement;
            if (parent instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)parent;
                return !(element instanceof JSIfStatement) || !element.equals(ifStatement.getElse());
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement) {
                return element.equals(((JSLoopStatement)parent).getBody());
            }
            return parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention$AddBracesPredicate", "satisfiedBy"));
        }
    }
}

