/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class JSFlipConditionalIntention
extends JSIntention {
    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("conditional.flip-conditional.display-name", new Object[0]);
        if (string == null) {
            JSFlipConditionalIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("conditional.flip-conditional.family-name", new Object[0]);
        if (string == null) {
            JSFlipConditionalIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new FlipConditionalPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSFlipConditionalIntention.$$$reportNull$$$0(2);
        }
        JSConditionalExpression exp = (JSConditionalExpression)element;
        JSExpression condition = exp.getCondition();
        JSExpression elseExpression = exp.getElse();
        JSExpression thenExpression = exp.getThen();
        assert (elseExpression != null);
        assert (thenExpression != null);
        String newExpression = BoolUtils.getNegatedExpressionText(condition) + "?" + elseExpression.getText() + ":" + thenExpression.getText();
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)newExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlipConditionalPredicate
    implements JSElementPredicate {
        private FlipConditionalPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                FlipConditionalPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            JSConditionalExpression condition = (JSConditionalExpression)element;
            return condition.getCondition() != null && condition.getThen() != null && condition.getElse() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention$FlipConditionalPredicate", "satisfiedBy"));
        }
    }
}

