/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ArithmeticPredicate;
import org.jetbrains.annotations.NotNull;

public class JSFlipArithmeticOperationIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(@NotNull PsiElement element) {
        JSBinaryExpression expression;
        if (element == null) {
            JSFlipArithmeticOperationIntention.$$$reportNull$$$0(0);
        }
        if ((expression = (JSBinaryExpression)ObjectUtils.tryCast((Object)element, JSBinaryExpression.class)) == null) {
            return "";
        }
        ASTNode node = expression.getOperationNode();
        if (node == null) {
            return "";
        }
        String signText = node.getText();
        return JSIntentionBundle.message("number.flip-arithmetic-operation.display-name", signText);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("number.flip-arithmetic-operation.family-name", new Object[0]);
        if (string == null) {
            JSFlipArithmeticOperationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSFlipArithmeticOperationIntention.$$$reportNull$$$0(2);
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        ASTNode sign = binaryExpression.getOperationNode();
        JSExpression lOperand = binaryExpression.getLOperand();
        JSExpression rOperand = binaryExpression.getROperand();
        if (sign == null || lOperand == null || rOperand == null) {
            return;
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)binaryExpression, (String)(rOperand.getText() + " " + sign.getText() + " " + lOperand.getText()));
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new ArithmeticPredicate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSFlipArithmeticOperationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSFlipArithmeticOperationIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextForElement";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

