/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Objects;
import org.languagetool.rules.patterns.PatternToken;

public class PatternTokenBuilder {
    private String token;
    private String posTag;
    private boolean marker = true;
    private boolean matchInflectedForms = false;
    private boolean caseSensitive;
    private boolean regexp;
    private boolean negation;
    private boolean isWhiteSpaceSet = false;
    private boolean isWhiteSpaceBefore;
    private int minOccurrence = 1;
    private int maxOccurrence = 1;
    private int skip;

    public PatternTokenBuilder token(String token) {
        this.token = Objects.requireNonNull(token);
        return this;
    }

    public PatternTokenBuilder csToken(String token) {
        this.token = Objects.requireNonNull(token);
        this.caseSensitive = true;
        return this;
    }

    public PatternTokenBuilder tokenRegex(String token) {
        this.token = Objects.requireNonNull(token);
        this.regexp = true;
        return this;
    }

    public PatternTokenBuilder csTokenRegex(String token) {
        this.token = Objects.requireNonNull(token);
        this.regexp = true;
        this.caseSensitive = true;
        return this;
    }

    public PatternTokenBuilder pos(String posTag) {
        return this.pos(posTag, false);
    }

    public PatternTokenBuilder posRegex(String posTag) {
        return this.pos(posTag, true);
    }

    public PatternTokenBuilder min(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("minOccurrence must be >= 0: " + this.minOccurrence);
        }
        this.minOccurrence = val;
        return this;
    }

    public PatternTokenBuilder max(int val) {
        this.maxOccurrence = val;
        return this;
    }

    public PatternTokenBuilder mark(boolean isMarked) {
        this.marker = isMarked;
        return this;
    }

    private PatternTokenBuilder pos(String posTag, boolean regexp) {
        this.posTag = Objects.requireNonNull(posTag);
        this.regexp = regexp;
        return this;
    }

    public PatternTokenBuilder negate() {
        this.negation = true;
        return this;
    }

    public PatternTokenBuilder setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public PatternTokenBuilder setIsWhiteSpaceBefore(boolean whiteSpaceBefore) {
        this.isWhiteSpaceBefore = whiteSpaceBefore;
        this.isWhiteSpaceSet = true;
        return this;
    }

    public PatternTokenBuilder matchInflectedForms() {
        this.matchInflectedForms = true;
        return this;
    }

    public PatternToken build() {
        PatternToken patternToken;
        if (this.posTag != null) {
            patternToken = new PatternToken(null, false, false, false);
            patternToken.setPosToken(new PatternToken.PosToken(this.posTag, this.regexp, false));
        } else {
            patternToken = new PatternToken(this.token, this.caseSensitive, this.regexp, this.matchInflectedForms);
        }
        if (this.isWhiteSpaceSet) {
            patternToken.setWhitespaceBefore(this.isWhiteSpaceBefore);
        }
        if (this.maxOccurrence < this.minOccurrence) {
            throw new IllegalArgumentException("minOccurrence must <= maxOccurrence: minOccurrence " + this.minOccurrence + ", maxOccurrence " + this.maxOccurrence);
        }
        patternToken.setMinOccurrence(this.minOccurrence);
        patternToken.setMaxOccurrence(this.maxOccurrence);
        patternToken.setNegation(this.negation);
        patternToken.setSkipNext(this.skip);
        patternToken.setInsideMarker(this.marker);
        return patternToken;
    }
}

