/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.parser;

import com.intellij.indentation.IndentPsiBuilder;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptPsiBuilder
extends IndentPsiBuilder {
    private final HashMap<PsiBuilder.Marker, List<List<String>>> myDeclarationStack = new HashMap();
    private List<List<String>> declaredVariables = new ArrayList<List<String>>();

    public CoffeeScriptPsiBuilder(PsiBuilder delegate) {
        super(delegate);
    }

    public void init() {
        int offset = this.getCurrentOffset();
        if (offset > 0) {
            String whiteSpaceText = this.myDelegate.getOriginalText().subSequence(0, offset).toString();
            int i = whiteSpaceText.lastIndexOf(10);
            this.myCurrentIndent = i >= 0 ? whiteSpaceText.length() - i - 1 : whiteSpaceText.length();
        }
    }

    public void advanceLexer() {
        do {
            IElementType previousTokenType = this.myDelegate.getTokenType();
            String tokenText = this.myDelegate.getTokenText();
            int tokenLength = tokenText == null ? 0 : tokenText.length();
            int whiteSpaceStart = this.getCurrentOffset() + tokenLength;
            this.myDelegate.advanceLexer();
            int whiteSpaceEnd = this.getCurrentOffset();
            String whiteSpaceText = this.myDelegate.getOriginalText().subSequence(whiteSpaceStart, whiteSpaceEnd).toString();
            this.myNewLine = false;
            int i = whiteSpaceText.lastIndexOf(10);
            if (i < 0) continue;
            if (previousTokenType == CoffeeScriptTokenTypes.SKIP_EOL) {
                i = whiteSpaceText.indexOf(10, i + 1);
            }
            if (i < 0) continue;
            int lastLineBreakPosition = whiteSpaceText.lastIndexOf(10);
            this.myCurrentIndent = whiteSpaceText.length() - lastLineBreakPosition - 1;
            this.myNewLine = true;
        } while (this.myDelegate.getTokenType() == CoffeeScriptTokenTypes.SKIP_EOL);
    }

    @NotNull
    public PsiBuilder.Marker markWithRollbackPossibility() {
        PsiBuilder.Marker marker = super.markWithRollbackPossibility();
        ArrayList result = new ArrayList(this.declaredVariables.size());
        for (List<String> scope : this.declaredVariables) {
            ArrayList<String> clonedScope = new ArrayList<String>(scope.size());
            clonedScope.addAll(scope);
            result.add(clonedScope);
        }
        this.myDeclarationStack.put(marker, result);
        PsiBuilder.Marker marker2 = marker;
        if (marker2 == null) {
            CoffeeScriptPsiBuilder.$$$reportNull$$$0(0);
        }
        return marker2;
    }

    public void setNewLine(boolean newLine) {
        this.myNewLine = newLine;
    }

    public void startScope() {
        this.declaredVariables.add(new ArrayList());
    }

    public void endScope() {
        this.declaredVariables.remove(this.declaredVariables.size() - 1);
    }

    public void addVariableInCurrentScope(@NotNull String variableName) {
        if (variableName == null) {
            CoffeeScriptPsiBuilder.$$$reportNull$$$0(1);
        }
        this.declaredVariables.get(this.declaredVariables.size() - 1).add(variableName);
    }

    public boolean isInScope(String name) {
        for (List<String> scope : this.declaredVariables) {
            if (!scope.contains(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PsiBuilder.Marker createDelegateMarker(@NotNull PsiBuilder.Marker delegate) {
        if (delegate == null) {
            CoffeeScriptPsiBuilder.$$$reportNull$$$0(2);
        }
        return new MyMarker(delegate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/lang/parser/CoffeeScriptPsiBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "markWithRollbackPossibility";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/lang/parser/CoffeeScriptPsiBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addVariableInCurrentScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDelegateMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMarker
    extends IndentPsiBuilder.MyMarker {
        MyMarker(PsiBuilder.Marker delegate) {
            if (delegate == null) {
                MyMarker.$$$reportNull$$$0(0);
            }
            super((IndentPsiBuilder)CoffeeScriptPsiBuilder.this, delegate);
        }

        public void rollbackTo() {
            List<List<String>> declaredVariablesForMarker = CoffeeScriptPsiBuilder.this.myDeclarationStack.get((Object)this);
            if (declaredVariablesForMarker != null) {
                CoffeeScriptPsiBuilder.this.declaredVariables = declaredVariablesForMarker;
            }
            CoffeeScriptPsiBuilder.this.myDeclarationStack.remove((Object)this);
            super.rollbackTo();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/coffeescript/lang/parser/CoffeeScriptPsiBuilder$MyMarker", "<init>"));
        }
    }
}

