import gdb
from common.Rtos import Rtos
from common import Reg
from common import rtos_class
from freertos.Task import get_freertos_tasks
from freertos.Task import get_curr_task
from freertos.cortex_m import get_arm_cm_freertos_stacking


regs = [
    Reg("sp", "", 4),
    Reg("pc", "", 4),
    Reg("lr", "", 4),
    Reg("r0", "", 4),
    Reg("r1", "", 4),
    Reg("r2", "", 4),
    Reg("r3", "", 4),
    Reg("r4", "", 4),
    Reg("r5", "", 4),
    Reg("r6", "", 4),
    Reg("r7", "", 4),
    Reg("r8", "", 4),
    Reg("r9", "", 4),
    Reg("r10", "", 4),
    Reg("r11", "", 4),
    Reg("r12", "", 4)
]


@rtos_class
class FreeRtos(Rtos):
    types = None

    def __init__(self):
        self.config = FreeRtosConfig()
        for field in FreeRtos.types.tcb_type.fields():
            if field.name == "uxTaskNumber":
                self.config.use_trace_facility = True
            if field.name == "ulRunTimeCounter":
                self.config.generate_runtime_stats = True
            if field.name == "uxBasePriority":
                self.config.use_mutexes = True
            if field.name == "pxEndOfStack":
                self.config.record_stack_high_address = True

        super(FreeRtos, self).__init__(FreeRtos.types.long_type)

    @staticmethod
    def detect():
        FreeRtos.types = TypesCache()
        if FreeRtos.types.tcb_type is None or FreeRtos.types.list_type is None:
            return False
        if FreeRtos.types.uint32_type is None or FreeRtos.types.long_type is None:
            return False
        if gdb.lookup_global_symbol("pxCurrentTCB") is None:
            return False
        return True

    @staticmethod
    def name():
        return "FreeRTOS"

    def get_threads(self):
        return get_freertos_tasks(self.config, FreeRtos.types)

    def get_current_thread(self):
        return get_curr_task(self.config, FreeRtos.types.tcb_type)

    def get_thread_registers(self):
        return regs

    def get_thread_stacking(self, stack_ptr):
        return get_arm_cm_freertos_stacking(stack_ptr, FreeRtos.types.uint32_type)


class TypesCache:
    def __init__(self):
        self.tcb_type = gdb.lookup_type("TCB_t")
        self.list_type = gdb.lookup_type("List_t")
        self.uint32_type = gdb.lookup_type("uint32_t")
        self.long_type = gdb.lookup_type("long")


class FreeRtosConfig:
    def __init__(self):
        self.use_trace_facility = False
        self.generate_runtime_stats = False
        self.use_mutexes = False
        self.record_stack_high_address = False


print("FreeRTOS initialized")
