/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.ProvidesMethodScanner;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProviderMethodsModule
implements Module {
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;
    private final boolean skipFastClassGeneration;
    private final ModuleAnnotatedMethodScanner scanner;

    private ProviderMethodsModule(Object delegate, boolean skipFastClassGeneration, ModuleAnnotatedMethodScanner scanner) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
        this.skipFastClassGeneration = skipFastClassGeneration;
        this.scanner = scanner;
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module, false, ProvidesMethodScanner.INSTANCE);
    }

    public static Module forModule(Object module, ModuleAnnotatedMethodScanner scanner) {
        return ProviderMethodsModule.forObject(module, false, scanner);
    }

    public static Module forObject(Object object) {
        return ProviderMethodsModule.forObject(object, true, ProvidesMethodScanner.INSTANCE);
    }

    private static Module forObject(Object object, boolean skipFastClassGeneration, ModuleAnnotatedMethodScanner scanner) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object, skipFastClassGeneration, scanner);
    }

    public Object getDelegateModule() {
        return this.delegate;
    }

    @Override
    public void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        ArrayList result = null;
        Class<?> superMostClass = this.delegate.getClass();
        for (Class<?> c = this.delegate.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                Annotation annotation = this.getAnnotation(binder, method);
                if (annotation == null) continue;
                if (result == null) {
                    result = Lists.newArrayList();
                }
                result.add(this.createProviderMethod(binder, method, annotation));
                superMostClass = c;
            }
        }
        if (result == null) {
            return ImmutableList.of();
        }
        HashMultimap<Signature, Method> methodsBySignature = null;
        for (Class<?> c = this.delegate.getClass(); c != superMostClass; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if ((method.getModifiers() & 0xA) != 0 || method.isBridge() || method.isSynthetic()) continue;
                if (methodsBySignature == null) {
                    methodsBySignature = HashMultimap.create();
                }
                methodsBySignature.put(new Signature(this.typeLiteral, method), method);
            }
        }
        if (methodsBySignature != null) {
            block4: for (ProviderMethod providerMethod : result) {
                Method method = providerMethod.getMethod();
                for (Method matchingSignature : methodsBySignature.get(new Signature(this.typeLiteral, method))) {
                    if (matchingSignature.getDeclaringClass().isAssignableFrom(method.getDeclaringClass()) || !ProviderMethodsModule.overrides(matchingSignature, method)) continue;
                    String annotationString = providerMethod.getAnnotation().annotationType() == Provides.class ? "@Provides" : "@" + providerMethod.getAnnotation().annotationType().getCanonicalName();
                    binder.addError("Overriding " + annotationString + " methods is not allowed.\n\t" + annotationString + " method: %s\n\toverridden by: %s", method, matchingSignature);
                    continue block4;
                }
            }
        }
        return result;
    }

    private Annotation getAnnotation(Binder binder, Method method) {
        if (method.isBridge() || method.isSynthetic()) {
            return null;
        }
        Annotation annotation = null;
        for (Class<? extends Annotation> clazz : this.scanner.annotationClasses()) {
            Annotation foundAnnotation = method.getAnnotation(clazz);
            if (foundAnnotation == null) continue;
            if (annotation != null) {
                binder.addError("More than one annotation claimed by %s on method %s. Methods can only have one annotation claimed per scanner.", this.scanner, method);
                return null;
            }
            annotation = foundAnnotation;
        }
        return annotation;
    }

    private static boolean overrides(Method a, Method b) {
        int modifiers = b.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    private <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method, Annotation annotation) {
        binder = binder.withSource(method);
        Errors errors2 = new Errors(method);
        InjectionPoint point = InjectionPoint.forMethod(method, this.typeLiteral);
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        Key<?> key2 = this.getKey(errors2, returnType, method, method.getAnnotations());
        try {
            key2 = this.scanner.prepareMethod(binder, annotation, key2, point);
        }
        catch (Throwable t) {
            binder.addError(t);
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors2, method.getAnnotations());
        for (Message message : errors2.getMessages()) {
            binder.addError(message);
        }
        return ProviderMethod.create(key2, method, this.delegate, ImmutableSet.copyOf(point.getDependencies()), scopeAnnotation, this.skipFastClassGeneration, annotation);
    }

    <T> Key<T> getKey(Errors errors2, TypeLiteral<T> type2, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors2, member, annotations);
        return bindingAnnotation == null ? Key.get(type2) : Key.get(type2, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof ProviderMethodsModule && ((ProviderMethodsModule)o).delegate == this.delegate && ((ProviderMethodsModule)o).scanner == this.scanner;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class Signature {
        final Class<?>[] parameters;
        final String name;
        final int hashCode;

        Signature(TypeLiteral<?> typeLiteral, Method method) {
            this.name = method.getName();
            List<TypeLiteral<?>> resolvedParameterTypes = typeLiteral.getParameterTypes(method);
            this.parameters = new Class[resolvedParameterTypes.size()];
            int i = 0;
            for (TypeLiteral<?> type2 : resolvedParameterTypes) {
                this.parameters[i] = type2.getRawType();
            }
            this.hashCode = this.name.hashCode() + 31 * Arrays.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature other = (Signature)obj;
                return other.name.equals(this.name) && Arrays.equals(this.parameters, other.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

