/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.export;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class TableExporter {
    private static final Logger LOG = Logger.getLogger(TableExporter.class);
    private static TableExporter instance;

    public static TableExporter getInstance() {
        if (instance == null) {
            instance = new TableExporter();
        }
        return instance;
    }

    private TableExporter() {
    }

    public void exportToExcel(JTable table, File file) throws IOException {
        LOG.info((Object)("Exporting table to Excel file: " + file.getAbsolutePath()));
        LOG.debug((Object)"Creating workbook");
        HSSFWorkbook wb = new HSSFWorkbook();
        FileOutputStream fileOut = new FileOutputStream(file);
        LOG.debug((Object)"Creating sheet");
        HSSFSheet bomSheet = wb.createSheet("B.O.M.");
        LOG.debug((Object)"Writing header row");
        HSSFRow headerRow = bomSheet.createRow(0);
        HSSFCellStyle headerStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        font.setFontName("Tahoma");
        headerStyle.setFont(font);
        headerStyle.setBorderBottom((short)1);
        headerStyle.setBorderTop((short)1);
        headerStyle.setBorderLeft((short)1);
        headerStyle.setBorderRight((short)1);
        headerStyle.setFillForegroundColor((short)40);
        headerStyle.setFillPattern((short)1);
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            HSSFCell cell = headerRow.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(table.getColumnName(i));
            cell.setCellStyle(headerStyle);
        }
        LOG.debug((Object)"Writing the data");
        HSSFCellStyle cellStyle = wb.createCellStyle();
        font = wb.createFont();
        font.setFontName("Tahoma");
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        for (int j = 0; j < table.getRowCount(); ++j) {
            HSSFRow row = bomSheet.createRow(j + 1);
            for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(cellStyle);
                int columnIdx = table.convertRowIndexToModel(i);
                Object value = table.getValueAt(j, i);
                if (value == null) continue;
                Class<?> clazz = table.getModel().getColumnClass(columnIdx);
                if (Short.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz)) {
                    cell.setCellType(0);
                    cell.setCellValue((double)((Short)value).intValue());
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
                    cell.setCellType(0);
                    cell.setCellValue((double)((Integer)value).intValue());
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
                    cell.setCellType(0);
                    cell.setCellValue((double)((Long)value).intValue());
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
                    cell.setCellType(0);
                    cell.setCellValue(((Float)value).doubleValue());
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
                    cell.setCellType(0);
                    cell.setCellValue(((Double)value).doubleValue());
                    continue;
                }
                cell.setCellType(1);
                cell.setCellValue(value.toString());
            }
        }
        LOG.debug((Object)"Auto-fitting columns");
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            bomSheet.autoSizeColumn(i);
        }
        LOG.debug((Object)"Writing to the file");
        wb.write((OutputStream)fileOut);
        fileOut.close();
        LOG.debug((Object)"Done");
    }

    public void exportToHTML(JTable table, File file) throws IOException {
        LOG.info((Object)("Exporting table to HTML file: " + file.getAbsolutePath()));
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("<html><body><font face=\"Tahoma\"><table cellspacing=\"0\" border=\"1\">\n");
        LOG.debug((Object)"Writing header row");
        out.write("  <tr>\n");
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            out.write("    <th align=\"left\" bgcolor=\"#00CCFF\">" + table.getColumnName(i) + "</th>\n");
        }
        out.write("  </tr>\n");
        LOG.debug((Object)"Writing the data");
        for (int j = 0; j < table.getRowCount(); ++j) {
            out.write("  <tr>\n");
            for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
                int rowIdx = table.convertRowIndexToModel(j);
                int columnIdx = table.convertRowIndexToModel(i);
                Object value = table.getValueAt(j, i);
                TableCellRenderer renderer = table.getCellRenderer(j, i);
                if (renderer != null) {
                    Component rendererComponent = renderer.getTableCellRendererComponent(table, value, false, false, rowIdx, columnIdx);
                    try {
                        Method method = rendererComponent.getClass().getMethod("getText", new Class[0]);
                        out.write("    <td>" + method.invoke((Object)rendererComponent, new Object[0]) + "</td>\n");
                    }
                    catch (Exception e) {
                        out.write("    <td>&nbsp;</td>\n");
                    }
                    continue;
                }
                out.write("    <td>&nbsp;</td>\n");
            }
            out.write("  </tr>\n");
        }
        out.write("</table></font></body></html>");
        out.close();
    }

    public void exportToCSV(JTable table, File file) throws IOException {
        LOG.info((Object)("Exporting table to CSV file: " + file.getAbsolutePath()));
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        LOG.debug((Object)"Writing header row");
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            if (i > 0) {
                out.write(",");
            }
            out.write(table.getColumnName(i));
        }
        out.write("\n");
        LOG.debug((Object)"Writing the data");
        for (int j = 0; j < table.getRowCount(); ++j) {
            for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
                if (i > 0) {
                    out.write(",");
                }
                int rowIdx = table.convertRowIndexToModel(j);
                int columnIdx = table.convertRowIndexToModel(i);
                Object value = table.getValueAt(j, i);
                TableCellRenderer renderer = table.getCellRenderer(j, i);
                if (renderer == null) continue;
                Component rendererComponent = renderer.getTableCellRendererComponent(table, value, false, false, rowIdx, columnIdx);
                try {
                    Method method = rendererComponent.getClass().getMethod("getText", new Class[0]);
                    out.write(method.invoke((Object)rendererComponent, new Object[0]).toString());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            out.write("\n");
        }
        out.close();
    }

    public void exportToPNG(JTable table, File file) throws IOException {
        LOG.info((Object)("Exporting table to PNG file: " + file.getAbsolutePath()));
        table.clearSelection();
        LOG.debug((Object)"Creating image");
        BufferedImage image = new BufferedImage(table.getWidth(), table.getHeight() + table.getTableHeader().getHeight(), 1);
        Graphics2D g2d = image.createGraphics();
        LOG.debug((Object)"Painting the header");
        table.getTableHeader().paint(g2d);
        LOG.debug((Object)"Painting the table");
        g2d.translate(0, table.getTableHeader().getHeight());
        table.paint(g2d);
        LOG.debug((Object)"Writing image to file");
        ImageIO.write((RenderedImage)image, "png", file);
        g2d.dispose();
    }
}

