/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.TimeRange;

public class TransportPostDataAction
extends TransportJobTaskAction<PostDataAction.Request, PostDataAction.Response> {
    private final AnalysisRegistry analysisRegistry;

    @Inject
    public TransportPostDataAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager, AnalysisRegistry analysisRegistry) {
        super(settings, "cluster:admin/xpack/ml/job/data/post", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, PostDataAction.Request::new, PostDataAction.Response::new, "same", processManager);
        this.analysisRegistry = analysisRegistry;
    }

    protected PostDataAction.Response readTaskResponse(StreamInput in) throws IOException {
        PostDataAction.Response response = new PostDataAction.Response();
        response.readFrom(in);
        return response;
    }

    protected void taskOperation(PostDataAction.Request request, TransportOpenJobAction.JobTask task, ActionListener<PostDataAction.Response> listener) {
        TimeRange timeRange = TimeRange.builder().startTime(request.getResetStart()).endTime(request.getResetEnd()).build();
        DataLoadParams params = new DataLoadParams(timeRange, Optional.ofNullable(request.getDataDescription()));
        try {
            this.processManager.processData(task, this.analysisRegistry, (InputStream)request.getContent().streamInput(), request.getXContentType(), params, (dataCounts, e) -> {
                if (dataCounts != null) {
                    listener.onResponse((Object)new PostDataAction.Response(dataCounts));
                } else {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }
}

