/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DatafeedNodeSelector {
    private static final Logger LOGGER = LogManager.getLogger(DatafeedNodeSelector.class);
    private final String datafeedId;
    private final String jobId;
    private final List<String> datafeedIndices;
    private final ClusterState clusterState;
    private final IndexNameExpressionResolver resolver;

    public DatafeedNodeSelector(ClusterState clusterState, IndexNameExpressionResolver resolver, String datafeedId, String jobId, List<String> datafeedIndices) {
        this.datafeedId = datafeedId;
        this.jobId = jobId;
        this.datafeedIndices = datafeedIndices;
        this.clusterState = Objects.requireNonNull(clusterState);
        this.resolver = Objects.requireNonNull(resolver);
    }

    public void checkDatafeedTaskCanBeCreated() {
        if (MlMetadata.getMlMetadata((ClusterState)this.clusterState).isUpgradeMode()) {
            String msg = "Unable to start datafeed [" + this.datafeedId + "] explanation [" + MlTasks.AWAITING_UPGRADE.getExplanation() + "]";
            LOGGER.debug(msg);
            IllegalStateException detail = new IllegalStateException(msg);
            throw new ElasticsearchStatusException("Could not start datafeed [" + this.datafeedId + "] as indices are being upgraded", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
        }
        AssignmentFailure assignmentFailure = this.checkAssignment(this.findJobTask());
        if (assignmentFailure != null && assignmentFailure.isCriticalForTaskCreation) {
            String msg = "No node found to start datafeed [" + this.datafeedId + "], allocation explanation [" + assignmentFailure.reason + "]";
            LOGGER.debug(msg);
            throw ExceptionsHelper.conflictStatusException((String)msg, (Object[])new Object[0]);
        }
    }

    public PersistentTasksCustomMetaData.Assignment selectNode() {
        if (MlMetadata.getMlMetadata((ClusterState)this.clusterState).isUpgradeMode()) {
            return MlTasks.AWAITING_UPGRADE;
        }
        PersistentTasksCustomMetaData.PersistentTask<?> jobTask = this.findJobTask();
        AssignmentFailure assignmentFailure = this.checkAssignment(jobTask);
        if (assignmentFailure == null) {
            return new PersistentTasksCustomMetaData.Assignment(jobTask.getExecutorNode(), "");
        }
        LOGGER.debug(assignmentFailure.reason);
        return new PersistentTasksCustomMetaData.Assignment(null, assignmentFailure.reason);
    }

    @Nullable
    private AssignmentFailure checkAssignment(PersistentTasksCustomMetaData.PersistentTask<?> jobTask) {
        String reason;
        PriorityFailureCollector priorityFailureCollector = new PriorityFailureCollector();
        priorityFailureCollector.add(this.verifyIndicesActive());
        JobTaskState jobTaskState = null;
        JobState jobState = JobState.CLOSED;
        if (jobTask != null) {
            jobTaskState = (JobTaskState)jobTask.getState();
            JobState jobState2 = jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
        }
        if (!jobState.isAnyOf(new JobState[]{JobState.OPENING, JobState.OPENED})) {
            reason = "cannot start datafeed [" + this.datafeedId + "], because the job's [" + this.jobId + "] state is [" + jobState + "] while state [" + JobState.OPENED + "] is required";
            priorityFailureCollector.add(new AssignmentFailure(reason, true));
        }
        if (jobTaskState != null && jobTaskState.isStatusStale(jobTask)) {
            reason = "cannot start datafeed [" + this.datafeedId + "], because the job's [" + this.jobId + "] state is stale";
            priorityFailureCollector.add(new AssignmentFailure(reason, true));
        }
        return priorityFailureCollector.get();
    }

    @Nullable
    private AssignmentFailure verifyIndicesActive() {
        for (String index : this.datafeedIndices) {
            String[] concreteIndices;
            if (RemoteClusterLicenseChecker.isRemoteIndex((String)index)) continue;
            String reason = "cannot start datafeed [" + this.datafeedId + "] because index [" + index + "] does not exist, is closed, or is still initializing.";
            try {
                concreteIndices = this.resolver.concreteIndexNames(this.clusterState, IndicesOptions.lenientExpandOpen(), new String[]{index});
                if (concreteIndices.length == 0) {
                    return new AssignmentFailure(reason, true);
                }
            }
            catch (Exception e) {
                LOGGER.debug(reason, (Throwable)e);
                return new AssignmentFailure(reason, true);
            }
            for (String concreteIndex : concreteIndices) {
                IndexRoutingTable routingTable = this.clusterState.getRoutingTable().index(concreteIndex);
                if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
                reason = "cannot start datafeed [" + this.datafeedId + "] because index [" + concreteIndex + "] does not have all primary shards active yet.";
                return new AssignmentFailure(reason, false);
            }
        }
        return null;
    }

    private PersistentTasksCustomMetaData.PersistentTask<?> findJobTask() {
        DatafeedConfig datafeedConfig;
        String foundJobId = this.jobId;
        if (this.jobId == null && (datafeedConfig = MlMetadata.getMlMetadata((ClusterState)this.clusterState).getDatafeed(this.datafeedId)) != null) {
            foundJobId = datafeedConfig.getJobId();
        }
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterState.getMetaData().custom("persistent_tasks");
        return MlTasks.getJobTask((String)foundJobId, (PersistentTasksCustomMetaData)tasks);
    }

    private static class PriorityFailureCollector {
        private AssignmentFailure failure;

        private PriorityFailureCollector() {
        }

        private void add(@Nullable AssignmentFailure newFailure) {
            if (newFailure == null) {
                return;
            }
            if (this.failure == null || !this.failure.isCriticalForTaskCreation && newFailure.isCriticalForTaskCreation) {
                this.failure = newFailure;
            }
        }

        @Nullable
        private AssignmentFailure get() {
            return this.failure;
        }
    }

    private static class AssignmentFailure {
        private final String reason;
        private final boolean isCriticalForTaskCreation;

        private AssignmentFailure(String reason, boolean isCriticalForTaskCreation) {
            this.reason = reason;
            this.isCriticalForTaskCreation = isCriticalForTaskCreation;
        }
    }
}

