/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;

public abstract class Similarity {
    public abstract long computeNorm(FieldInvertState var1);

    public abstract SimWeight computeWeight(float var1, CollectionStatistics var2, TermStatistics ... var3);

    public abstract SimScorer simScorer(SimWeight var1, LeafReaderContext var2) throws IOException;

    public static abstract class SimWeight {
    }

    public static abstract class SimScorer {
        public abstract float score(int var1, float var2) throws IOException;

        @Deprecated
        public abstract float computeSlopFactor(int var1);

        @Deprecated
        public abstract float computePayloadFactor(int var1, int var2, int var3, BytesRef var4);

        public Explanation explain(int doc, Explanation freq) throws IOException {
            return Explanation.match(this.score(doc, freq.getValue()), "score(doc=" + doc + ",freq=" + freq.getValue() + "), with freq of:", Collections.singleton(freq));
        }
    }
}

