/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SigningConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class SamlRedirect {
    private final SAMLObject samlObject;
    private final String destination;
    private final String parameterName;
    private final SigningConfiguration signing;

    public SamlRedirect(RequestAbstractType request, SigningConfiguration signing) {
        this.samlObject = request;
        this.destination = request.getDestination();
        this.parameterName = "SAMLRequest";
        this.signing = signing;
    }

    public SamlRedirect(StatusResponseType response, SigningConfiguration signing) {
        this.samlObject = response;
        this.destination = response.getDestination();
        this.parameterName = "SAMLResponse";
        this.signing = signing;
    }

    public String getRedirectUrl() throws ElasticsearchException {
        return this.getRedirectUrl(null);
    }

    public String getRedirectUrl(String relayState) throws ElasticsearchException {
        try {
            String request = this.deflateAndBase64Encode(this.samlObject);
            String queryParam = this.parameterName + "=" + this.urlEncode(request);
            if (relayState != null) {
                queryParam = queryParam + "&RelayState=" + this.urlEncode(relayState);
            }
            if (this.signing.shouldSign(this.samlObject)) {
                String algo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                queryParam = queryParam + "&SigAlg=" + this.urlEncode("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                byte[] sig = this.signing.sign(queryParam, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                queryParam = queryParam + "&Signature=" + this.urlEncode(this.base64Encode(sig));
            }
            return this.withParameters(queryParam);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Cannot construct SAML redirect", (Throwable)e, new Object[0]);
        }
    }

    private String withParameters(String queryParam) {
        if (this.destination.indexOf(63) == -1) {
            return this.destination + "?" + queryParam;
        }
        if (this.destination.endsWith("?")) {
            return this.destination + queryParam;
        }
        return this.destination + "&" + queryParam;
    }

    private String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private String urlEncode(String param) throws UnsupportedEncodingException {
        return URLEncoder.encode(param, StandardCharsets.US_ASCII.name());
    }

    protected String deflateAndBase64Encode(SAMLObject message) throws Exception {
        Deflater deflater = new Deflater(8, true);
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            String string;
            try (DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);){
                String messageStr = SamlUtils.toString(XMLObjectSupport.marshall((XMLObject)message));
                deflaterStream.write(messageStr.getBytes(StandardCharsets.UTF_8));
                deflaterStream.finish();
                string = this.base64Encode(bytesOut.toByteArray());
            }
            return string;
        }
    }
}

