/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class PutCalendarAction
extends Action<Request, Response, RequestBuilder> {
    public static final PutCalendarAction INSTANCE = new PutCalendarAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/put";

    private PutCalendarAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Calendar calendar;

        public Response() {
        }

        public Response(Calendar calendar) {
            this.calendar = calendar;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().before(Version.V_6_3_0)) {
                in.readBoolean();
            }
            this.calendar = new Calendar(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().before(Version.V_6_3_0)) {
                out.writeBoolean(true);
            }
            this.calendar.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.calendar.toXContent(builder, params);
        }

        public int hashCode() {
            return Objects.hash(this.calendar);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.calendar, other.calendar);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private Calendar calendar;

        public static Request parseRequest(String calendarId, XContentParser parser) {
            Calendar.Builder builder = (Calendar.Builder)Calendar.STRICT_PARSER.apply(parser, null);
            if (builder.getId() == null) {
                builder.setId(calendarId);
            } else if (!Strings.isNullOrEmpty((String)calendarId) && !calendarId.equals(builder.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", Calendar.ID.getPreferredName(), builder.getId(), calendarId));
            }
            return new Request(builder.build());
        }

        public Request() {
        }

        public Request(Calendar calendar) {
            this.calendar = ExceptionsHelper.requireNonNull(calendar, "calendar");
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if ("_all".equals(this.calendar.getId())) {
                validationException = ValidateActions.addValidationError((String)"Cannot create a Calendar with the reserved name [_all]", validationException);
            }
            if (!MlStrings.isValidId(this.calendar.getId())) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", Calendar.ID.getPreferredName(), this.calendar.getId()), (ActionRequestValidationException)validationException);
            }
            if (!MlStrings.hasValidLengthForId(this.calendar.getId())) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("The job id cannot contain more than {0,number,integer} characters.", 64), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.calendar = new Calendar(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.calendar.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.calendar.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.calendar);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendar, other.calendar);
        }
    }
}

