/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class InvalidateTokenRequest
extends ActionRequest {
    private String tokenString;
    private Type tokenType;
    private String realmName;
    private String userName;

    public InvalidateTokenRequest() {
    }

    public InvalidateTokenRequest(@Nullable String tokenString, @Nullable String tokenType, @Nullable String realmName, @Nullable String userName) {
        this.tokenString = tokenString;
        this.tokenType = Type.fromString(tokenType);
        this.realmName = realmName;
        this.userName = userName;
    }

    public InvalidateTokenRequest(String tokenString, String tokenType) {
        this.tokenString = tokenString;
        this.tokenType = Type.fromString(tokenType);
        this.realmName = null;
        this.userName = null;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName)) {
            if (Strings.hasText((String)this.tokenString)) {
                validationException = ValidateActions.addValidationError((String)"token string must not be provided when realm name or username is specified", null);
            }
            if (this.tokenType != null) {
                validationException = ValidateActions.addValidationError((String)"token type must not be provided when realm name or username is specified", (ActionRequestValidationException)validationException);
            }
        } else if (Strings.isNullOrEmpty((String)this.tokenString)) {
            validationException = ValidateActions.addValidationError((String)"token string must be provided when not specifying a realm name or a username", null);
        } else if (this.tokenType == null) {
            validationException = ValidateActions.addValidationError((String)"token type must be provided when a token string is specified", null);
        }
        return validationException;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    void setTokenString(String token) {
        this.tokenString = token;
    }

    public Type getTokenType() {
        return this.tokenType;
    }

    void setTokenType(Type tokenType) {
        this.tokenType = tokenType;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_6_0)) {
            if (Strings.isNullOrEmpty((String)this.tokenString)) {
                throw new IllegalArgumentException("token is required for versions  < v6.6.0");
            }
            out.writeString(this.tokenString);
        } else {
            out.writeOptionalString(this.tokenString);
        }
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            if (out.getVersion().before(Version.V_6_6_0)) {
                if (this.tokenType == null) {
                    throw new IllegalArgumentException("token type is not optional for versions > v6.2.0 and < v6.6.0");
                }
                out.writeVInt(this.tokenType.ordinal());
            } else {
                out.writeOptionalVInt(this.tokenType == null ? null : Integer.valueOf(this.tokenType.ordinal()));
            }
        } else if (this.tokenType == Type.REFRESH_TOKEN) {
            throw new IllegalArgumentException("refresh token invalidation cannot be serialized with version [" + out.getVersion() + "]");
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalString(this.realmName);
            out.writeOptionalString(this.userName);
        } else if (this.realmName != null || this.userName != null) {
            throw new IllegalArgumentException("realm or user token invalidation cannot be serialized with version [" + out.getVersion() + "]");
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tokenString = in.getVersion().before(Version.V_6_6_0) ? in.readString() : in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            if (in.getVersion().before(Version.V_6_6_0)) {
                int type = in.readVInt();
                this.tokenType = Type.values()[type];
            } else {
                Integer type = in.readOptionalVInt();
                this.tokenType = type == null ? null : Type.values()[type];
            }
        } else {
            this.tokenType = Type.ACCESS_TOKEN;
        }
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.realmName = in.readOptionalString();
            this.userName = in.readOptionalString();
        }
    }

    public static enum Type {
        ACCESS_TOKEN("token"),
        REFRESH_TOKEN("refresh_token");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Type fromString(String tokenType) {
            if (tokenType != null) {
                for (Type type : Type.values()) {
                    if (!type.getValue().equals(tokenType)) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

