/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.function.scalar.CastProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Cast
extends UnaryScalarFunction {
    private final DataType dataType;

    public Cast(Source source, Expression field, DataType dataType) {
        super(source, field);
        this.dataType = dataType;
    }

    @Override
    protected NodeInfo<Cast> info() {
        return NodeInfo.create(this, Cast::new, this.field(), this.dataType);
    }

    @Override
    protected UnaryScalarFunction replaceChild(Expression newChild) {
        return new Cast(this.source(), newChild, this.dataType);
    }

    public DataType from() {
        return this.field().dataType();
    }

    public DataType to() {
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return DataTypeConversion.convert(this.field().fold(), this.dataType);
    }

    @Override
    public Nullability nullable() {
        if (DataTypes.isNull(this.from())) {
            return Nullability.TRUE;
        }
        return Nullability.UNKNOWN;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return DataTypeConversion.canConvert(this.from(), this.to()) ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("Cannot cast [" + (Object)((Object)this.from()) + "] to [" + (Object)((Object)this.to()) + "]");
    }

    @Override
    protected Processor makeProcessor() {
        return new CastProcessor(DataTypeConversion.conversionFor(this.from(), this.to()));
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate fieldAsScript = this.asScript(this.field());
        return new ScriptTemplate(this.formatTemplate(LoggerMessageFormat.format((String)"{sql}.", (String)"cast({},{})", (Object[])new Object[]{fieldAsScript.template()})), ParamsBuilder.paramsBuilder().script(fieldAsScript.params()).variable(this.dataType.name()).build(), this.dataType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.dataType});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Cast other = (Cast)obj;
        return Objects.equals((Object)this.dataType, (Object)other.dataType()) && Objects.equals(this.field(), other.field());
    }
}

