/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NonIsoDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

abstract class NonIsoDateTimeFunction
extends BaseDateTimeFunction {
    private final NonIsoDateTimeProcessor.NonIsoDateTimeExtractor extractor;

    NonIsoDateTimeFunction(Source source, Expression field, ZoneId zoneId, NonIsoDateTimeProcessor.NonIsoDateTimeExtractor extractor) {
        super(source, field, zoneId);
        this.extractor = extractor;
    }

    @Override
    protected Object doFold(ZonedDateTime dateTime) {
        return this.extractor.extract(dateTime);
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.formatTemplate(String.format(Locale.ROOT, "{sql}.%s(doc[{}].value, {})", StringUtils.underscoreToLowerCamelCase(this.extractor.name()))), ParamsBuilder.paramsBuilder().variable(field.name()).variable(this.zoneId().getId()).build(), this.dataType());
    }

    @Override
    protected Processor makeProcessor() {
        return new NonIsoDateTimeProcessor(this.extractor, this.zoneId());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }
}

