/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

abstract class StringFunctionUtils {
    StringFunctionUtils() {
    }

    static String substring(String s, int start, int length) {
        if (!StringFunctionUtils.hasLength(s)) {
            return s;
        }
        if (start < 0) {
            start = 0;
        }
        if (start + 1 > s.length() || length < 0) {
            return "";
        }
        return start + length > s.length() ? s.substring(start) : s.substring(start, start + length);
    }

    static String trimTrailingWhitespaces(String s) {
        if (!StringFunctionUtils.hasLength(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static String trimLeadingWhitespaces(String s) {
        if (!StringFunctionUtils.hasLength(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private static boolean hasLength(String s) {
        return s != null && s.length() > 0;
    }
}

