/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;

public class GroupByNumericHistogram
extends GroupByKey {
    private final double interval;

    public GroupByNumericHistogram(String id, String fieldName, double interval) {
        this(id, fieldName, null, null, interval);
    }

    public GroupByNumericHistogram(String id, ScriptTemplate script, double interval) {
        this(id, null, script, null, interval);
    }

    private GroupByNumericHistogram(String id, String fieldName, ScriptTemplate script, Sort.Direction direction, double interval) {
        super(id, fieldName, script, direction);
        this.interval = interval;
    }

    @Override
    protected CompositeValuesSourceBuilder<?> createSourceBuilder() {
        return new HistogramValuesSourceBuilder(this.id()).interval(this.interval);
    }

    @Override
    protected GroupByKey copy(String id, String fieldName, ScriptTemplate script, Sort.Direction direction) {
        return new GroupByNumericHistogram(id, fieldName, script, direction, this.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupByNumericHistogram other = (GroupByNumericHistogram)obj;
            return this.interval == other.interval;
        }
        return false;
    }
}

