/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import com.sun.media.format.WavAudioFormat;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaEncoder_ms
extends BufferedEncoder {
    private IMA4State ima4stateL;
    private IMA4State ima4stateR;
    private int inputframeSizeInBytes = 1010;

    public JavaEncoder_ms() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new WavAudioFormat("ima4/ms")};
        this.PLUGIN_NAME = "IMA4 MS Encoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        int outFrameSizeInBits = ((this.inputframeSizeInBytes - 2) * 2 + 32) * af.getChannels();
        int wSamplesPerBlock = this.inputframeSizeInBytes / 2;
        this.supportedOutputFormats = new AudioFormat[]{new WavAudioFormat("ima4/ms", af.getSampleRate(), 4, af.getChannels(), outFrameSizeInBits, (int)af.getSampleRate() * 2 / 8 * outFrameSizeInBits / this.inputframeSizeInBytes, -1, -1, -1.0f, Format.byteArray, new byte[]{(byte)(wSamplesPerBlock & 0xFF), (byte)(wSamplesPerBlock >> 8)})};
        this.historySize = this.inputframeSizeInBytes * af.getChannels();
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4stateL = new IMA4State();
        this.ima4stateR = new IMA4State();
    }

    public void close() {
        this.ima4stateL = null;
        this.ima4stateR = null;
    }

    public void codecReset() {
        this.ima4stateL.index = 0;
        this.ima4stateL.valprev = 0;
        this.ima4stateR.index = 0;
        this.ima4stateR.valprev = 0;
    }

    protected int calculateOutputSize(int inputSize) {
        return this.calculateFramesNumber(inputSize) * ((this.inputframeSizeInBytes - 4) * 4 + 2);
    }

    protected int calculateFramesNumber(int inputSize) {
        return inputSize / this.inputframeSizeInBytes;
    }

    protected boolean codecProcess(byte[] inpData, int readPtr, byte[] outData, int writePtr, int inpLength, int[] readBytes, int[] writeBytes, int[] frameNumber, int[] regions, int[] regiostypes) {
        int inCount = 0;
        int outCount = 0;
        int channels = this.inputFormat.getChannels();
        boolean isStereo = channels == 2;
        int stride = isStereo ? 2 : 0;
        int frames = inpLength / (channels * 1010);
        int iterations = this.inputframeSizeInBytes - 2 >> 1;
        regions[0] = writePtr;
        int frameCounter = 0;
        while (frameCounter < frames) {
            int valprev = inpData[readPtr + inCount++] & 0xFF;
            this.ima4stateL.valprev = valprev |= inpData[readPtr + inCount++] << 8;
            if (this.ima4stateL.index > 88) {
                this.ima4stateL.index = 88;
            } else if (this.ima4stateL.index < 0) {
                this.ima4stateL.index = 0;
            }
            outData[writePtr + outCount++] = (byte)valprev;
            outData[writePtr + outCount++] = (byte)(valprev >> 8);
            outData[writePtr + outCount++] = (byte)this.ima4stateL.index;
            ++outCount;
            if (isStereo) {
                valprev = inpData[readPtr + inCount++] & 0xFF;
                this.ima4stateR.valprev = valprev |= inpData[readPtr + inCount++] << 8;
                if (this.ima4stateR.index > 88) {
                    this.ima4stateR.index = 88;
                } else if (this.ima4stateR.index < 0) {
                    this.ima4stateR.index = 0;
                }
                outData[writePtr + outCount++] = (byte)valprev;
                outData[writePtr + outCount++] = (byte)(valprev >> 8);
                outData[writePtr + outCount++] = (byte)this.ima4stateR.index;
                ++outCount;
            }
            int loop = 0;
            while (loop < iterations / 8) {
                IMA4.encode(inpData, inCount + readPtr, outData, outCount + writePtr, 8, this.ima4stateL, stride);
                outCount += 4;
                if (isStereo) {
                    IMA4.encode(inpData, inCount + readPtr + 2, outData, outCount + writePtr, 8, this.ima4stateR, stride);
                    outCount += 4;
                    inCount += 32;
                } else {
                    inCount += 16;
                }
                ++loop;
            }
            regions[frameCounter + 1] = outCount + writePtr;
            this.regionsTypes[frameCounter] = 0;
            ++frameCounter;
        }
        readBytes[0] = inCount;
        writeBytes[0] = outCount;
        frameNumber[0] = frames;
        return true;
    }
}

