/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.awt.Component;
import javax.swing.JRootPane;
import org.flexdock.docking.Dockable;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.RootWindow;

public class NestedComponents {
    public Component searchSrc;
    public Component child;
    public Component parent;

    public static NestedComponents find(Component searchSrc, Class childClass, Class parentClass) {
        if (searchSrc == null || childClass == null || parentClass == null) {
            return null;
        }
        NestedComponents nest = new NestedComponents(searchSrc, null, null);
        for (Component c = searchSrc; c != null && !(c instanceof JRootPane); c = c.getParent()) {
            if (nest.child == null && NestedComponents.isInstanceOf(c, childClass)) {
                nest.child = c;
                continue;
            }
            if (!NestedComponents.isParentContainer(c, parentClass)) continue;
            nest.parent = c;
            break;
        }
        return nest;
    }

    private static boolean isParentContainer(Component c, Class parentClass) {
        if (parentClass == RootWindow.class) {
            return RootWindow.isValidRootContainer(c);
        }
        return parentClass.isAssignableFrom(c.getClass());
    }

    private static boolean isInstanceOf(Object obj, Class clazz) {
        if (clazz.isAssignableFrom(obj.getClass())) {
            return true;
        }
        if (clazz == Dockable.class) {
            return DockingUtility.isDockable(obj);
        }
        return false;
    }

    private NestedComponents(Component searchSrc, Component child, Component parent) {
        this.searchSrc = searchSrc;
        this.child = child;
        this.parent = parent;
    }

    public boolean isFull() {
        return this.child != null && this.parent != null;
    }

    public int hashCode() {
        int h = this.searchSrc.hashCode();
        h += this.child == null ? 0 : this.child.hashCode();
        return h += this.parent == null ? 0 : this.parent.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NestedComponents)) {
            return false;
        }
        NestedComponents other = (NestedComponents)obj;
        return this.searchSrc == other.searchSrc && this.child == other.child && this.parent == other.parent;
    }
}

