//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _TRACK_H
#define _TRACK_H 

#include "trk_hdr_type.h"
#include "trk_point_type.h"

#include <vector>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// one track can stored and accesed with this class
class Track : GPDLineTool
{
   public:
      typedef vector<Trk_Point_Type> Trackpoints;

      /// builds an empty track
      Track() { }

      /// initializes a new track
      Track(const string &name);

      /// returns the gpd-string of the i-th trackpoint 
      string operator[] (int t);        //

      /// retuns the header as gpd
      string header();

      /// returns the number of waypoints in the list
      int size(void) const;
   
      /// add data in gpd format
      void is(string);
      /// same as is , for convenience
      void operator<<(string);


      /// output the whole data as a String
      string os(void);
      /// output to ostream
      void os(ostream &);

      /// return the ith track point
      const Trk_Point_Type &get(unsigned int i) const
	{ return trackpoints[i]; }

      /// return the track name
      const string &getName() const { return trackheader.getName(); }

      /// return the track points vector
      const Trackpoints &getList() const { return trackpoints; }

      /// add a waypoint to the track
      void add(Trk_Point_Type &trackpoint)
	{ trackpoints.push_back(trackpoint); }
      
      /// check whether the track is empty
      bool empty() const { return trackpoints.empty(); }
      
      /// clear the track vector
      void clear() { trackpoints.clear(); }

   private:
      Trackpoints trackpoints;
      Trk_Hdr_Type trackheader;

};

}
#endif
