/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.thirdparty.common.css.SubstitutionMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RenamingSubstitutionMap
implements SubstitutionMap {
    private final Map<String, String> replacementMap;
    private Set<String> classes;
    private Set<String> externalClassCandidates;

    public RenamingSubstitutionMap(Map<String, Map<String, String>> replacementsWithPrefix) {
        this.replacementMap = this.computeReplacementMap(replacementsWithPrefix);
        this.classes = new HashSet<String>();
        this.externalClassCandidates = new HashSet<String>();
    }

    private Map<String, String> computeReplacementMap(Map<String, Map<String, String>> replacementsWithPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> entry : replacementsWithPrefix.entrySet()) {
            String prefix = entry.getKey();
            HashMap<String, String> replacement = new HashMap<String, String>();
            for (Map.Entry<String, String> replacementEntry : entry.getValue().entrySet()) {
                replacement.put(prefix + replacementEntry.getKey(), replacementEntry.getValue());
            }
            result.putAll(replacement);
        }
        return result;
    }

    public String get(String key) {
        this.classes.add(key);
        String replacement = this.replacementMap.get(key);
        if (replacement == null) {
            this.externalClassCandidates.add(key);
            return key;
        }
        return replacement;
    }

    public Set<String> getStyleClasses() {
        return this.classes;
    }

    public Set<String> getExternalClassCandidates() {
        return this.externalClassCandidates;
    }
}

