/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.Random;
import tokyocabinet.FDB;
import tokyocabinet.Util;

class FDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            FDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = FDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = FDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = FDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = FDBTest.runmisc(stringArray);
        } else {
            FDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static void usage() {
        STDERR.println("test cases of the fixed-length database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        STDERR.println("  java " + FDBTest.class.getName() + " arguments...");
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tchtest.rb write [-nl|-nb] path rnum [width [limsiz]]");
        STDERR.println("  tchtest.rb read [-nl|-nb] path");
        STDERR.println("  tchtest.rb remove [-nl|-nb] path");
        STDERR.println("  tchtest.rb misc [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static void eprint(FDB fDB, String string) {
        String string2 = fDB.path();
        STDERR.println(FDBTest.class.getName() + ": " + string2 + ": " + string + ": " + fDB.errmsg());
    }

    private static int runwrite(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string5 = stringArray[n];
            if (string == null && string5.startsWith("-")) {
                if (string5.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string5.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                FDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string5;
                continue;
            }
            if (string2 == null) {
                string2 = string5;
                continue;
            }
            if (string3 == null) {
                string3 = string5;
                continue;
            }
            if (string4 == null) {
                string4 = string5;
                continue;
            }
            FDBTest.usage();
        }
        if (string == null || string2 == null) {
            FDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            FDBTest.usage();
        }
        int n3 = string3 != null ? Util.atoi(string3) : -1;
        long l = string4 != null ? Util.atol(string4) : -1L;
        int n4 = FDBTest.procwrite(string, n, n3, l, n2);
        return n4;
    }

    private static int runread(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                FDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            FDBTest.usage();
        }
        if (string == null) {
            FDBTest.usage();
        }
        n = FDBTest.procread(string, n2);
        return n;
    }

    private static int runremove(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                FDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            FDBTest.usage();
        }
        if (string == null) {
            FDBTest.usage();
        }
        n = FDBTest.procremove(string, n2);
        return n;
    }

    private static int runmisc(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string3.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                FDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            FDBTest.usage();
        }
        if (string == null || string2 == null) {
            FDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            FDBTest.usage();
        }
        int n3 = FDBTest.procmisc(string, n, n2);
        return n3;
    }

    private static int procwrite(String string, int n, int n2, long l, int n3) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  width=" + n2 + "  limsiz=" + l + "  omode=" + n3);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.tune(n2, l)) {
            FDBTest.eprint(fDB, "tune");
            bl = true;
        }
        if (!fDB.open(string, 0xE | n3)) {
            FDBTest.eprint(fDB, "open");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!fDB.put(string2, string2)) {
                FDBTest.eprint(fDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.open(string, 1 | n)) {
            FDBTest.eprint(fDB, "open");
            bl = true;
        }
        int n2 = (int)fDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (fDB.get(string2) == null) {
                FDBTest.eprint(fDB, "get");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.open(string, 2 | n)) {
            FDBTest.eprint(fDB, "open");
            bl = true;
        }
        int n2 = (int)fDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!fDB.out(string2)) {
                FDBTest.eprint(fDB, "out");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procmisc(String string, int n, int n2) {
        String string2;
        Object object;
        String string3;
        int n3;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  omode=" + n2);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.tune(10, 1024 + 32 * n)) {
            FDBTest.eprint(fDB, "tune");
            bl = true;
        }
        if (!fDB.open(string, 0xE | n2)) {
            FDBTest.eprint(fDB, "open");
            bl = true;
        }
        STDOUT.println("writing:");
        for (n3 = 1; n3 <= n; ++n3) {
            string3 = Util.itoa(n3, 8, '0');
            if (!fDB.put(string3, string3)) {
                FDBTest.eprint(fDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || n3 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n3 != n && n3 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string3 + ")");
        }
        STDOUT.println("reading:");
        for (n3 = 1; n3 <= n; ++n3) {
            string3 = Util.itoa(n3, 8, '0');
            if (fDB.get(string3) == null) {
                FDBTest.eprint(fDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n3 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n3 != n && n3 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string3 + ")");
        }
        STDOUT.println("removing:");
        for (n3 = 1; n3 <= n; ++n3) {
            string3 = Util.itoa(n3, 8, '0');
            if (RND.nextInt(2) == 0 && !fDB.out(string3)) {
                FDBTest.eprint(fDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n3 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n3 != n && n3 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string3 + ")");
        }
        STDOUT.println("checking iterator:");
        if (!fDB.iterinit()) {
            FDBTest.eprint(fDB, "iterinit");
            bl = true;
        }
        n3 = 0;
        while ((string3 = fDB.iternext2()) != null) {
            object = fDB.get(string3);
            if (object == null) {
                FDBTest.eprint(fDB, "get");
                bl = true;
            }
            if (n3 > 0 && n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
                }
            }
            ++n3;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
        }
        if (fDB.ecode() != 22 || (long)n3 != fDB.rnum()) {
            FDBTest.eprint(fDB, "(validation)");
            bl = true;
        }
        object = fDB.range("[min,max]", 10);
        if (fDB.rnum() >= 10L && object.size() != 10) {
            FDBTest.eprint(fDB, "range");
            bl = true;
        }
        STDOUT.println("checking counting:");
        for (int i = 1; i <= n; ++i) {
            String string4 = "[" + (RND.nextInt(n) + 1) + "]";
            if (RND.nextInt(2) == 0) {
                if (fDB.addint(string4, 1) == Integer.MIN_VALUE && fDB.ecode() != 21) {
                    FDBTest.eprint(fDB, "addint");
                    bl = true;
                    break;
                }
            } else if (fDB.adddouble(string4, 1.0) == -2.147483648E9 && fDB.ecode() != 21) {
                FDBTest.eprint(fDB, "adddouble");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!fDB.sync()) {
            FDBTest.eprint(fDB, "sync");
            bl = true;
        }
        if (!fDB.optimize()) {
            FDBTest.eprint(fDB, "optimize");
            bl = true;
        }
        if (!fDB.copy(string2 = string + "-tmp")) {
            FDBTest.eprint(fDB, "copy");
            bl = true;
        }
        new File(string2).delete();
        if (!fDB.vanish()) {
            FDBTest.eprint(fDB, "vanish");
            bl = true;
        }
        STDOUT.println("checking transaction commit:");
        if (!fDB.tranbegin()) {
            FDBTest.eprint(fDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string5 = i + "";
            if (RND.nextInt(2) == 0) {
                if (!fDB.putcat(string5, string5)) {
                    FDBTest.eprint(fDB, "putcat");
                    bl = true;
                    break;
                }
            } else if (!fDB.out(string5) && fDB.ecode() != 22) {
                FDBTest.eprint(fDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!fDB.trancommit()) {
            FDBTest.eprint(fDB, "trancommit");
            bl = true;
        }
        STDOUT.println("checking transaction abort:");
        long l = fDB.rnum();
        long l2 = fDB.fsiz();
        if (!fDB.tranbegin()) {
            FDBTest.eprint(fDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string6 = i + "";
            if (RND.nextInt(2) == 0) {
                if (!fDB.putcat(string6, string6)) {
                    FDBTest.eprint(fDB, "putcat");
                    bl = true;
                    break;
                }
            } else if (!fDB.out(string6) && fDB.ecode() != 22) {
                FDBTest.eprint(fDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!fDB.tranabort()) {
            FDBTest.eprint(fDB, "trancommit");
            bl = true;
        }
        if (fDB.rnum() != l || fDB.fsiz() != l2) {
            FDBTest.eprint(fDB, "(validation)");
            bl = true;
        }
        STDOUT.println("checking common interface:");
        FDB fDB2 = fDB;
        for (int i = 1; i <= n; ++i) {
            String string7 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + "]";
            int n4 = RND.nextInt(3);
            if (n4 == 0) {
                fDB2.put(string7, string7);
            } else if (n4 == 1) {
                fDB2.get(string7);
            } else {
                fDB2.out(string7);
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        STDOUT.println("checking iterator:");
        n3 = 0;
        if (!fDB2.iterinit()) {
            FDBTest.eprint(fDB, "iterinit");
            bl = true;
        }
        while ((string3 = fDB2.iternext2()) != null) {
            String string8 = fDB2.get(string3);
            if (string8 == null) {
                FDBTest.eprint(fDB, "get");
                bl = true;
            }
            if (n3 > 0 && n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
                }
            }
            ++n3;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private FDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

