/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.ArrayList;
import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BIPush;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.SIPush;
import jd.core.process.analyzer.util.ReconstructorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitArrayInstructionReconstructor {
    public static void Reconstruct(List<Instruction> list) {
        int index = list.size() - 1;
        while (index >= 0) {
            Instruction i = list.get(index);
            if (i.opcode == 264) {
                DupStore dupStore = (DupStore)i;
                int opcode = dupStore.objectref.opcode;
                if (opcode == 188 || opcode == 189) {
                    InitArrayInstructionReconstructor.ReconstructAInstruction(list, index, dupStore);
                }
            }
            --index;
        }
    }

    private static void ReconstructAInstruction(List<Instruction> list, int index, DupStore dupStore) {
        int length = list.size();
        int firstDupStoreIndex = index;
        DupStore lastDupStore = dupStore;
        ArrayStoreInstruction lastAsi = null;
        int arrayIndex = 0;
        ArrayList<Instruction> values = new ArrayList<Instruction>();
        while (++index < length) {
            Instruction i = list.get(index);
            if (i.opcode != 83 && i.opcode != 272) break;
            ArrayStoreInstruction asi = (ArrayStoreInstruction)i;
            if (asi.arrayref.opcode != 263 || asi.arrayref.offset != lastDupStore.offset) break;
            lastAsi = asi;
            int indexOfArrayStoreInstruction = InitArrayInstructionReconstructor.getArrayIndex(asi.indexref);
            while (indexOfArrayStoreInstruction > arrayIndex) {
                values.add(new IConst(256, asi.offset, asi.lineNumber, 0));
                ++arrayIndex;
            }
            values.add(asi.valueref);
            ++arrayIndex;
            if (++index >= length) break;
            i = list.get(index);
            if (i.opcode != 264) break;
            DupStore nextDupStore = (DupStore)i;
            if (nextDupStore.objectref.opcode != 263 || nextDupStore.objectref.offset != lastDupStore.offset) break;
            lastDupStore = nextDupStore;
        }
        if (lastAsi != null) {
            InitArrayInstruction iai = new InitArrayInstruction(283, lastAsi.offset, dupStore.lineNumber, dupStore.objectref, values);
            Instruction parent = ReconstructorUtil.ReplaceDupLoad(list, index, lastDupStore, iai);
            if (parent != null) {
                switch (parent.opcode) {
                    case 83: {
                        iai.opcode = 282;
                    }
                }
            }
            while (firstDupStoreIndex < index) {
                list.remove(--index);
            }
            if (iai.newArray.opcode == 188) {
                NewArray na = (NewArray)iai.newArray;
                switch (na.type) {
                    case 4: {
                        InitArrayInstructionReconstructor.SetContantTypes("Z", iai.values);
                        break;
                    }
                    case 5: {
                        InitArrayInstructionReconstructor.SetContantTypes("C", iai.values);
                        break;
                    }
                    case 8: {
                        InitArrayInstructionReconstructor.SetContantTypes("B", iai.values);
                        break;
                    }
                    case 9: {
                        InitArrayInstructionReconstructor.SetContantTypes("S", iai.values);
                        break;
                    }
                    case 10: {
                        InitArrayInstructionReconstructor.SetContantTypes("I", iai.values);
                    }
                }
            }
        }
    }

    private static void SetContantTypes(String signature, List<Instruction> values) {
        int length = values.size();
        int i = 0;
        while (i < length) {
            Instruction value = values.get(i);
            switch (value.opcode) {
                case 16: 
                case 17: 
                case 256: {
                    ((IConst)value).setReturnedSignature(signature);
                }
            }
            ++i;
        }
    }

    private static int getArrayIndex(Instruction i) {
        switch (i.opcode) {
            case 256: {
                return ((IConst)i).value;
            }
            case 16: {
                return ((BIPush)i).value;
            }
            case 17: {
                return ((SIPush)i).value;
            }
        }
        return -1;
    }
}

