/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.jetty.plus.jaas.JAASPrincipal;
import org.eclipse.jetty.plus.jaas.JAASRole;
import org.eclipse.jetty.plus.jaas.callback.ObjectCallback;
import org.eclipse.jetty.plus.jaas.spi.UserInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private boolean authState = false;
    private boolean commitState = false;
    private JAASUserInfo currentUser;
    private Subject subject;

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject s) {
        this.subject = s;
    }

    public JAASUserInfo getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(JAASUserInfo u) {
        this.currentUser = u;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler h) {
        this.callbackHandler = h;
    }

    public boolean isAuthenticated() {
        return this.authState;
    }

    public boolean isCommitted() {
        return this.commitState;
    }

    public void setAuthenticated(boolean authState) {
        this.authState = authState;
    }

    public void setCommitted(boolean commitState) {
        this.commitState = commitState;
    }

    @Override
    public boolean abort() throws LoginException {
        this.currentUser = null;
        return this.isAuthenticated() && this.isCommitted();
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.currentUser = null;
            this.setCommitted(false);
            return false;
        }
        this.setCommitted(true);
        this.currentUser.setJAASInfo(this.subject);
        return true;
    }

    public Callback[] configureCallbacks() {
        Callback[] callbacks = new Callback[]{new NameCallback("Enter user name"), new ObjectCallback(), new PasswordCallback("Enter password", false)};
        return callbacks;
    }

    public abstract UserInfo getUserInfo(String var1) throws Exception;

    @Override
    public boolean login() throws LoginException {
        try {
            if (this.callbackHandler == null) {
                throw new LoginException("No callback handler");
            }
            Callback[] callbacks = this.configureCallbacks();
            this.callbackHandler.handle(callbacks);
            String webUserName = ((NameCallback)callbacks[0]).getName();
            Object webCredential = null;
            webCredential = ((ObjectCallback)callbacks[1]).getObject();
            if (webCredential == null) {
                webCredential = ((PasswordCallback)callbacks[2]).getPassword();
            }
            if (webUserName == null || webCredential == null) {
                this.setAuthenticated(false);
                return this.isAuthenticated();
            }
            UserInfo userInfo = this.getUserInfo(webUserName);
            if (userInfo == null) {
                this.setAuthenticated(false);
                return this.isAuthenticated();
            }
            this.currentUser = new JAASUserInfo(userInfo);
            this.setAuthenticated(this.currentUser.checkCredential(webCredential));
            return this.isAuthenticated();
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(e.toString());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.currentUser.unsetJAASInfo(this.subject);
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
    }

    public class JAASUserInfo {
        private UserInfo user;
        private Principal principal;
        private List<JAASRole> roles;

        public JAASUserInfo(UserInfo u) {
            this.setUserInfo(u);
        }

        public String getUserName() {
            return this.user.getUserName();
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public void setUserInfo(UserInfo u) {
            this.user = u;
            this.principal = new JAASPrincipal(u.getUserName());
            this.roles = new ArrayList<JAASRole>();
            if (u.getRoleNames() != null) {
                Iterator<String> itor = u.getRoleNames().iterator();
                while (itor.hasNext()) {
                    this.roles.add(new JAASRole(itor.next()));
                }
            }
        }

        public void setJAASInfo(Subject subject) {
            subject.getPrincipals().add(this.principal);
            subject.getPrivateCredentials().add(this.user.getCredential());
            subject.getPrincipals().addAll(this.roles);
        }

        public void unsetJAASInfo(Subject subject) {
            subject.getPrincipals().remove(this.principal);
            subject.getPrivateCredentials().remove(this.user.getCredential());
            subject.getPrincipals().removeAll(this.roles);
        }

        public boolean checkCredential(Object suppliedCredential) {
            return this.user.checkCredential(suppliedCredential);
        }
    }
}

