/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import org.apache.kafka.common.utils.Time;

public class Throttle {
    private final int maxPerPeriod;
    private final int periodMs;
    private int count;
    private long prevPeriod;

    Throttle(int maxPerPeriod, int periodMs) {
        this.maxPerPeriod = maxPerPeriod;
        this.periodMs = periodMs;
        this.count = maxPerPeriod;
        this.prevPeriod = -1L;
    }

    public synchronized boolean increment() throws InterruptedException {
        boolean throttled = false;
        while (true) {
            if (this.count < this.maxPerPeriod) {
                ++this.count;
                return throttled;
            }
            long now = this.time().milliseconds();
            long curPeriod = now / (long)this.periodMs;
            if (curPeriod <= this.prevPeriod) {
                long nextPeriodMs = (curPeriod + 1L) * (long)this.periodMs;
                this.delay(nextPeriodMs - now);
                throttled = true;
                continue;
            }
            this.prevPeriod = curPeriod;
            this.count = 0;
        }
    }

    protected Time time() {
        return Time.SYSTEM;
    }

    protected synchronized void delay(long amount) throws InterruptedException {
        if (amount > 0L) {
            this.wait(amount);
        }
    }
}

