/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

public enum ResourceType {
    UNKNOWN(0),
    ANY(1),
    TOPIC(2),
    GROUP(3),
    BROKER(4);

    private static final ResourceType[] VALUES;
    private final byte id;

    private ResourceType(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static ResourceType forId(byte id) {
        if (id < 0) {
            throw new IllegalArgumentException("id should be positive, id: " + id);
        }
        if (id >= VALUES.length) {
            return UNKNOWN;
        }
        return VALUES[id];
    }

    static {
        VALUES = ResourceType.values();
    }
}

