/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u0001\u0003\u0001%\u0011A&\u00129pG\"$%/\u001b<f]J+\u0007\u000f\\5dCRLwN\u001c)s_R|7m\u001c7BG\u000e,\u0007\u000f^1oG\u0016$Vm\u001d;\u000b\u0005\r!\u0011!B3q_\u000eD'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tAB\u0003\u0002\u000e\r\u0005\u0011!p[\u0005\u0003\u001f1\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u0006i>\u0004\u0018nY\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005Y\u0006twMC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#AB*ue&tw\r\u0003\u0004(\u0001\u0001\u0006IAH\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005\u0019Qn]4\u0016\u0003-\u00022\u0001L\u00182\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#!B!se\u0006L\bC\u0001\u00173\u0013\t\u0019TF\u0001\u0003CsR,\u0007BB\u001b\u0001A\u0003%1&\u0001\u0003ng\u001e\u0004\u0003bB\u001c\u0001\u0005\u0004%\tAK\u0001\n[N<')[4hKJDa!\u000f\u0001!\u0002\u0013Y\u0013AC7tO\nKwmZ3sA!91\b\u0001a\u0001\n\u0003a\u0014a\u00022s_.,'o]\u000b\u0002{A\u0019aHR%\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"\t\u0003\u0019a$o\\8u}%\ta&\u0003\u0002F[\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005\r\u0019V-\u001d\u0006\u0003\u000b6\u0002\"AS&\u000e\u0003\u0011I!\u0001\u0014\u0003\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b\u001d\u0002\u0001\r\u0011\"\u0001P\u0003-\u0011'o\\6feN|F%Z9\u0015\u0005A\u001b\u0006C\u0001\u0017R\u0013\t\u0011VF\u0001\u0003V]&$\bb\u0002+N\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\n\u0004B\u0002,\u0001A\u0003&Q(\u0001\u0005ce>\\WM]:!\u0011\u001dA\u0006\u00011A\u0005\u0002e\u000b\u0001\u0002\u001d:pIV\u001cWM]\u000b\u00025B!1\fZ\u0016,\u001b\u0005a&B\u0001-^\u0015\tqv,A\u0004dY&,g\u000e^:\u000b\u0005\u001d\u0001'BA1c\u0003\u0019\t\u0007/Y2iK*\t1-A\u0002pe\u001eL!!\u001a/\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d9\u0007\u00011A\u0005\u0002!\fA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001U5\t\u000fQ3\u0017\u0011!a\u00015\"11\u000e\u0001Q!\ni\u000b\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\t\u000f5\u0004\u0001\u0019!C\u0001]\u0006A1m\u001c8tk6,'/F\u0001p!\u0011\u0001(oK\u0016\u000e\u0003ET!!\\/\n\u0005M\f(!D&bM.\f7i\u001c8tk6,'\u000fC\u0004v\u0001\u0001\u0007I\u0011\u0001<\u0002\u0019\r|gn];nKJ|F%Z9\u0015\u0005A;\bb\u0002+u\u0003\u0003\u0005\ra\u001c\u0005\u0007s\u0002\u0001\u000b\u0015B8\u0002\u0013\r|gn];nKJ\u0004\u0003bB>\u0001\u0005\u0004%\t\u0001`\u0001\u0010\u0017&\u0003v,\r\u00192?\u0016s\u0015I\u0011'F\tV\tQ\u0010\u0005\u0002-}&\u0011q0\f\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nu\f\u0001cS%Q?F\u0002\u0014gX#O\u0003\ncU\t\u0012\u0011\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u0005)1/\u001a;VaR\t\u0001\u000b\u000b\u0003\u0002\u0006\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M!-A\u0003kk:LG/\u0003\u0003\u0002\u0018\u0005E!A\u0002\"fM>\u0014X\rC\u0004\u0002\u001c\u0001!\t%!\u0003\u0002\u0011Q,\u0017M\u001d#po:DC!!\u0007\u0002 A!\u0011qBA\u0011\u0013\u0011\t\u0019#!\u0005\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002\n\u0005!3\u000f[8vY\u00124u\u000e\u001c7po2+\u0017\rZ3s\u000bB|7\r\u001b\"bg&\u001cwk\u001c:lM2|w\u000f\u000b\u0003\u0002&\u0005-\u0002\u0003BA\b\u0003[IA!a\f\u0002\u0012\t!A+Z:u\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003\u0013\t1d\u001d5pk2$gj\u001c;BY2|w\u000fR5wKJ<WM\u001c;M_\u001e\u001c\b\u0006BA\u0019\u0003WAq!!\u000f\u0001\t\u0003\tI!A\u000epM\u001a\u001cX\r^:TQ>,H\u000e\u001a(pi\u001e{')Y2lo\u0006\u0014Hm\u001d\u0015\u0005\u0003o\tY\u0003C\u0004\u0002@\u0001!\t!!\u0003\u0002;MDw.\u001e7e'V\u0014h/\u001b<f\r\u0006\u001cH\u000fT3bI\u0016\u00148\t[1oO\u0016DC!!\u0010\u0002,!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0013a\u00017pOR)\u0001+!\u0013\u0002N!9\u00111JA\"\u0001\u0004I\u0015A\u00027fC\u0012,'\u000fC\u0004\u0002P\u0005\r\u0003\u0019A%\u0002\u0011\u0019|G\u000e\\8xKJDq!a\u0015\u0001\t\u0013\t)&\u0001\nxC&$hi\u001c:M_\u001e\u001cHk\\'bi\u000eDGc\u0002)\u0002X\u0005m\u0013q\f\u0005\b\u00033\n\t\u00061\u0001J\u0003\t\u0011\u0017\u0007C\u0004\u0002^\u0005E\u0003\u0019A%\u0002\u0005\t\u0014\u0004BCA1\u0003#\u0002\n\u00111\u0001\u0002d\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0004Y\u0005\u0015\u0014bAA4[\t\u0019\u0011J\u001c;\t\u000f\u0005-\u0004\u0001\"\u0003\u0002\n\u0005i\u0001O]5oiN+w-\\3oiNDq!a\u001c\u0001\t\u0013\t\t(A\u0007ti\u0006\u0014HoQ8ogVlWM\u001d\u000b\u0002_\"9\u0011Q\u000f\u0001\u0005\n\u0005]\u0014!\u00073fY\u0016$X-T3tg\u0006<Wm\u001d$s_6dun\u001a$jY\u0016$r\u0001UA=\u0003\u0007\u000b9\t\u0003\u0005\u0002|\u0005M\u0004\u0019AA?\u0003\u0015\u0011\u0017\u0010^3t!\ra\u0013qP\u0005\u0004\u0003\u0003k#\u0001\u0002'p]\u001eDq!!\"\u0002t\u0001\u0007\u0011*\u0001\u0004ce>\\WM\u001d\u0005\t\u0003\u0013\u000b\u0019\b1\u0001\u0002d\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\ti\t\u0001C\u0005\u0003\u001f\u000b\u0011CY;gM\u0016\u0014\u0018N\\4Qe>$WoY3s)\u0005Q\u0006bBAJ\u0001\u0011%\u0011QS\u0001\u000bO\u0016$Hj\\4GS2,GCBAL\u0003G\u000b)\u000b\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\tiJI\u0001\u0003S>LA!!)\u0002\u001c\n!a)\u001b7f\u0011\u001d\t))!%A\u0002%C\u0001\"!\u0019\u0002\u0012\u0002\u0007\u00111\r\u0005\b\u0003S\u0003A\u0011BAV\u0003\u00199W\r\u001e'pOR1\u0011QVA\\\u0003s\u0003B!a,\u000246\u0011\u0011\u0011\u0017\u0006\u0004\u0003\u000b2\u0011\u0002BA[\u0003c\u00131\u0001T8h\u0011\u001d\t))a*A\u0002%C\u0001\"!\u0019\u0002(\u0002\u0007\u00111\r\u0005\b\u0003{\u0003A\u0011BA`\u0003\u0019\u0011w.\u001e8dKR\u0019\u0001+!1\t\u000f\u0005=\u00131\u0018a\u0001\u0013\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0017AC3q_\u000eD7)Y2iKR!\u0011\u0011ZAh!\rQ\u00121Z\u0005\u0004\u0003\u001b\u0014!\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\rC\u0004\u0002\u0006\u0006\r\u0007\u0019A%\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\u0006aA.\u0019;fgR\u0014VmY8sIRA\u0011q[At\u0003S\fi\u000f\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\rI,7m\u001c:e\u0015\r\t\toX\u0001\u0007G>lWn\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eC\u0004\u0002L\u0005E\u0007\u0019A%\t\u0015\u0005-\u0018\u0011\u001bI\u0001\u0002\u0004\t\u0019'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u000b\u0003C\n\t\u000e%AA\u0002\u0005\r\u0004bBAy\u0001\u0011%\u00111_\u0001\tC^\f\u0017\u000e^%T%R\u0019\u0001+!>\t\u0011\u0005]\u0018q\u001ea\u0001\u0003s\f!\u0001\u001e9\u0011\t\u0005m\u0018Q`\u0007\u0003\u0003?LA!a@\u0002`\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u0002\u0001\u0011%\u0011qR\u0001\u000fGJ,\u0017\r^3Qe>$WoY3s\u0011\u001d\tY\u0005\u0001C\u0005\u0005\u000f!\u0012!\u0013\u0005\b\u0003\u001f\u0002A\u0011\u0002B\u0004\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\tAb\u0019:fCR,'I]8lKJ$2!\u0013B\t\u0011!\u0011\u0019Ba\u0003A\u0002\u0005\r\u0014AA5e\r\u0019\u00119\u0002\u0001\u0003\u0003\u001a\t\u00012\u000b^;c\t\u0016\u001cXM]5bY&TXM]\n\u0007\u0005+\u0011YB!\t\u0011\u0007}\u0011i\"C\u0002\u0003 \u0001\u0012aa\u00142kK\u000e$\b#\u0002B\u0012\u0005SYSB\u0001B\u0013\u0015\u0011\u00119#a8\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\u0011YC!\n\u0003\u0019\u0011+7/\u001a:jC2L'0\u001a:\t\u000f]\u0011)\u0002\"\u0001\u00030Q\u0011!\u0011\u0007\t\u0005\u0005g\u0011)\"D\u0001\u0001\u0011!\u00119D!\u0006\u0005B\te\u0012!C2p]\u001aLw-\u001e:f)\u0015\u0001&1\bB9\u0011!\u0011iD!\u000eA\u0002\t}\u0012aB2p]\u001aLwm\u001d\u0019\u0005\u0005\u0003\u0012y\u0006\u0005\u0005\u0003D\t%#Q\nB.\u001b\t\u0011)EC\u0002\u0003H\t\nA!\u001e;jY&!!1\nB#\u0005\ri\u0015\r\u001d\t\u0005\u0005\u001f\u00129F\u0004\u0003\u0003R\tM\u0003C\u0001!.\u0013\r\u0011)&L\u0001\u0007!J,G-\u001a4\n\u0007\u0015\u0012IFC\u0002\u0003V5\u0002BA!\u0018\u0003`1\u0001A\u0001\u0004B1\u0005w\t\t\u0011!A\u0003\u0002\t\r$aA0%cE!!Q\rB6!\ra#qM\u0005\u0004\u0005Sj#a\u0002(pi\"Lgn\u001a\t\u0004Y\t5\u0014b\u0001B8[\t\u0019\u0011I\\=\t\u000f\tM$Q\u0007a\u0001{\u0006)\u0011n]&fs\"A!q\u000fB\u000b\t\u0003\u0012I(A\u0006eKN,'/[1mSj,G#B\u0016\u0003|\tu\u0004b\u0002\u000f\u0003v\u0001\u0007!Q\n\u0005\b\u0005\u007f\u0012)\b1\u0001,\u0003\u0011!\u0017\r^1\t\u0011\t\r%Q\u0003C!\u0003\u0013\tQa\u00197pg\u0016D\u0011Ba\"\u0001#\u0003%IA!#\u0002-1\fG/Z:u%\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uII*\"Aa#+\t\u0005\r$QR\u0016\u0003\u0005\u001f\u0003BA!%\u0003\u001c6\u0011!1\u0013\u0006\u0005\u0005+\u00139*A\u0005v]\u000eDWmY6fI*\u0019!\u0011T\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001e\nM%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u0015\u0001\u0012\u0002\u0013%!\u0011R\u0001\u0017Y\u0006$Xm\u001d;SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%g!I!Q\u0015\u0001\u0012\u0002\u0013%!\u0011R\u0001\u001do\u0006LGOR8s\u0019><7\u000fV8NCR\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class EpochDrivenReplicationProtocolAcceptanceTest
extends ZooKeeperTestHarness {
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Seq<KafkaServer> brokers = null;
    private KafkaProducer<byte[], byte[]> producer = null;
    private KafkaConsumer<byte[], byte[]> consumer = null;
    private final boolean KIP_101_ENABLED;

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public boolean KIP_101_ENABLED() {
        return this.KIP_101_ENABLED;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldFollowLeaderEpochBasicWorkflow() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$1 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$13 = this.topic();
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        Properties x$15 = qual$1.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$16 = qual$1.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$1.createOrUpdateTopicPartitionAssignmentPathInZK(x$13, (Map)x$14, x$15, x$16);
        this.producer_$eq(this.createProducer());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((long)0L, (long)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((long)0L, (long)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.bounce(this.follower());
        this.awaitISR(tp);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        Assert.assertEquals((long)1L, (long)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((long)1L, (long)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        this.bounce(this.leader());
        this.awaitISR(tp);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((long)2L, (long)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((long)2L, (long)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.follower()).epochEntries());
    }

    @Test
    public void shouldNotAllowDivergentLogs() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)id -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        AdminZkClient qual$2 = this.adminZkClient();
        String x$17 = this.topic();
        scala.collection.immutable.Map x$18 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        Properties x$19 = qual$2.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$20 = qual$2.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$2.createOrUpdateTopicPartitionAssignmentPathInZK(x$17, (Map)x$18, x$19, x$20);
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            b.shutdown();
            return BoxedUnit.UNIT;
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), Log$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(5 * this.msg().length, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        Assert.assertEquals((String)"Log files should match Broker0 vs Broker 1", (long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length());
    }

    @Test
    public void offsetsShouldNotGoBackwards() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$3 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())));
        AdminZkClient qual$3 = this.adminZkClient();
        String x$21 = this.topic();
        scala.collection.immutable.Map x$22 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        Properties x$23 = qual$3.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$24 = qual$3.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$3.createOrUpdateTopicPartitionAssignmentPathInZK(x$21, (Map)x$22, x$23, x$24);
        this.producer_$eq(this.bufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            b.shutdown();
            return BoxedUnit.UNIT;
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), Log$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length() / 2L, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.bufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable & scala.Serializable)x$4 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$4(this, BoxesRunTime.unboxToInt((Object)x$4)));
        this.producer().flush();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable & scala.Serializable)x$5 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$5(this, BoxesRunTime.unboxToInt((Object)x$5)));
        this.producer().flush();
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        this.startConsumer();
        Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.consumer().poll(1000L)).asScala();
        LongRef prevOffset = LongRef.create((long)-1L);
        records.foreach((Function1 & Serializable & scala.Serializable)r -> {
            EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$6(prevOffset, r);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Log files should match Broker0 vs Broker 1", (long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length());
    }

    @Test
    public void shouldSurviveFastLeaderChange() {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$6 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom())));
        AdminZkClient qual$4 = this.adminZkClient();
        String x$25 = this.topic();
        scala.collection.immutable.Map x$26 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        Properties x$27 = qual$4.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$28 = qual$4.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$4.createOrUpdateTopicPartitionAssignmentPathInZK(x$25, (Map)x$26, x$27, x$28);
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        IntRef messagesWritten = IntRef.create((int)1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
            KafkaServer leader = (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$3(leaderId, x$7)))).apply(0);
            KafkaServer follower = (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$4(leaderId, x$8)))).apply(0);
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
            ++messagesWritten$1.elem;
            this.bounce(follower);
            this.log(leader, follower);
            this.awaitISR(tp);
            this.bounce(leader);
            this.log(leader, follower);
            this.awaitISR(tp);
            Assert.assertTrue((boolean)this.brokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$5(this, messagesWritten, broker))));
        });
    }

    private void log(KafkaServer leader, KafkaServer follower) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bounce complete for follower ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)follower.config().brokerId())})));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader: leo", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leader.config().brokerId())})) + this.getLog(leader, 0).logEndOffset() + " cache: " + this.epochCache(leader).epochEntries());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower: leo", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)follower.config().brokerId())})) + this.getLog(follower, 0).logEndOffset() + " cache: " + this.epochCache(follower).epochEntries());
    }

    private void waitForLogsToMatch(KafkaServer b1, KafkaServer b2, int partition) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.getLog(b1, partition).logEndOffset() == this.getLog(b2, partition).logEndOffset(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Logs didn't match.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private int waitForLogsToMatch$default$3() {
        return 0;
    }

    private void printSegments() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker0:");
        DumpLogSegments$.MODULE$.main((String[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--files", this.getLogFile((KafkaServer)this.brokers().apply(0), 0).getCanonicalPath()}))).toArray(ClassTag$.MODULE$.apply(String.class)));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker1:");
        DumpLogSegments$.MODULE$.main((String[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--files", this.getLogFile((KafkaServer)this.brokers().apply(1), 0).getCanonicalPath()}))).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private KafkaConsumer<byte[], byte[]> startConsumer() {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        consumerConfig.put("fetch.max.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        consumerConfig.put("max.partition.fetch.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        this.consumer_$eq((KafkaConsumer<byte[], byte[]>)new KafkaConsumer(consumerConfig, (Deserializer)new StubDeserializer(), (Deserializer)new StubDeserializer()));
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0)}))).asJava());
        this.consumer().seek(new TopicPartition(this.topic(), 0), 0L);
        return this.consumer();
    }

    private void deleteMessagesFromLogFile(long bytes, KafkaServer broker, int partitionId) {
        File logFile = this.getLogFile(broker, partitionId);
        RandomAccessFile writable = new RandomAccessFile(logFile, "rwd");
        writable.setLength(logFile.length() - bytes);
        writable.close();
    }

    private KafkaProducer<byte[], byte[]> bufferingProducer() {
        String x$29 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$30 = 5;
        int x$31 = -1;
        long x$32 = 10000L;
        Option x$33 = Option$.MODULE$.apply((Object)CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"batch.size", (Object)String.valueOf(this.msg().length * 1000)), new Tuple2((Object)"compression.type", (Object)"snappy")})));
        long x$34 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$35 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$36 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$37 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$38 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$39 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$40 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$41 = TestUtils$.MODULE$.createNewProducer$default$12();
        return TestUtils$.MODULE$.createNewProducer(x$29, x$31, x$34, x$35, x$30, x$32, x$36, x$37, x$38, x$39, x$40, x$41, (Option<Properties>)x$33);
    }

    private File getLogFile(KafkaServer broker, int partition) {
        Log log = this.getLog(broker, partition);
        log.flush();
        return ((File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])log.dir().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$getLogFile$1(x$9))))[0];
    }

    private Log getLog(KafkaServer broker, int partition) {
        LogManager qual$5 = broker.logManager();
        TopicPartition x$42 = new TopicPartition(this.topic(), partition);
        boolean x$43 = qual$5.getLog$default$2();
        return (Log)qual$5.getLog(x$42, x$43).orNull(Predef$.MODULE$.$conforms());
    }

    private void bounce(KafkaServer follower) {
        follower.shutdown();
        follower.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private LeaderEpochFileCache epochCache(KafkaServer broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache();
    }

    private RecordBatch latestRecord(KafkaServer leader, int offset, int partition) {
        LogSegment qual$6 = this.getLog(leader, partition).activeSegment();
        long x$44 = 0L;
        None$ x$45 = None$.MODULE$;
        int x$46 = Integer.MAX_VALUE;
        long x$47 = qual$6.read$default$4();
        boolean x$48 = qual$6.read$default$5();
        return (RecordBatch)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(qual$6.read(x$44, (Option)x$45, x$46, x$47, x$48).records().batches()).asScala()).toSeq().last();
    }

    private int latestRecord$default$2() {
        return -1;
    }

    private int latestRecord$default$3() {
        return 0;
    }

    private void awaitISR(TopicPartition tp) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)((Partition)this.leader().replicaManager().getPartition(tp).get()).inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom())).size() == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for replicas to join ISR", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        String x$49 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$50 = 5;
        int x$51 = -1;
        long x$52 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$53 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$54 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$55 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$56 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$57 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$58 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$59 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$60 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$61 = TestUtils$.MODULE$.createNewProducer$default$13();
        return TestUtils$.MODULE$.createNewProducer(x$49, x$51, x$52, x$53, x$50, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61);
    }

    private KafkaServer leader() {
        Assert.assertEquals((long)2L, (long)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$leader$1(leaderId, x$11)))).apply(0);
    }

    private KafkaServer follower() {
        Assert.assertEquals((long)2L, (long)this.brokers().size());
        int leader = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$follower$1(leader, x$12)))).apply(0);
    }

    private KafkaServer createBroker(int id) {
        Object object;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        if (!this.KIP_101_ENABLED()) {
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), KAFKA_0_11_0_IV1$.MODULE$.version());
            object = config.setProperty(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), KAFKA_0_11_0_IV1$.MODULE$.version());
        } else {
            object = BoxedUnit.UNIT;
        }
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$4(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$4) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$5(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$5) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ void $anonfun$offsetsShouldNotGoBackwards$6(LongRef prevOffset$1, ConsumerRecord r) {
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset ", " came before ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)prevOffset$1.elem), BoxesRunTime.boxToLong((long)r.offset())})), (r.offset() > prevOffset$1.elem ? 1 : 0) != 0);
        prevOffset$1.elem = r.offset();
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$3(int leaderId$1, KafkaServer x$7) {
        return x$7.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$4(int leaderId$1, KafkaServer x$8) {
        return x$8.config().brokerId() != leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$5(EpochDrivenReplicationProtocolAcceptanceTest $this, IntRef messagesWritten$1, KafkaServer broker) {
        return $this.getLog(broker, 0).logEndOffset() == (long)messagesWritten$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getLogFile$1(File x$9) {
        return x$9.getName().endsWith(".log");
    }

    public static final /* synthetic */ boolean $anonfun$leader$1(int leaderId$2, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$follower$1(int leader$2, KafkaServer x$12) {
        return x$12.config().brokerId() != leader$2;
    }

    public EpochDrivenReplicationProtocolAcceptanceTest() {
        this.topic = "topic1";
        this.KIP_101_ENABLED = true;
    }

    public class StubDeserializer
    implements Deserializer<byte[]> {
        public void configure(java.util.Map<String, ?> configs, boolean isKey) {
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }

        public void close() {
        }

        public /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$StubDeserializer$$$outer() {
            return EpochDrivenReplicationProtocolAcceptanceTest.this;
        }

        public StubDeserializer() {
            if (EpochDrivenReplicationProtocolAcceptanceTest.this == null) {
                throw null;
            }
        }
    }
}

