/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.table;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nu.validator.checker.AttributeUtil;
import nu.validator.checker.table.Cell;
import nu.validator.checker.table.ColumnRange;
import nu.validator.checker.table.RowGroup;
import nu.validator.checker.table.TableChecker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

final class Table {
    private State state = State.IN_TABLE_AT_START;
    private int suppressedStarts = 0;
    private boolean hardWidth = false;
    private int columnCount = -1;
    private int realColumnCount = 0;
    private int pendingColGroupSpan = 0;
    private final Set<String> headerIds = new HashSet<String>();
    private final List<Cell> cellsReferringToHeaders = new LinkedList<Cell>();
    private final TableChecker owner;
    private RowGroup current;
    private ColumnRange first = null;
    private ColumnRange last = null;
    private ColumnRange currentColRange = null;
    private ColumnRange previousColRange = null;

    public Table(TableChecker owner) {
        this.owner = owner;
    }

    private boolean needSuppressStart() {
        if (this.suppressedStarts > 0) {
            ++this.suppressedStarts;
            return true;
        }
        return false;
    }

    private boolean needSuppressEnd() {
        if (this.suppressedStarts > 0) {
            --this.suppressedStarts;
            return true;
        }
        return false;
    }

    void startRowGroup(String type) throws SAXException {
        if (this.needSuppressStart()) {
            return;
        }
        switch (this.state) {
            case IN_IMPLICIT_ROW_GROUP: {
                this.current.end();
            }
            case IN_TABLE_AT_START: 
            case IN_TABLE_COLS_SEEN: 
            case IN_TABLE_AT_POTENTIAL_ROW_GROUP_START: {
                this.current = new RowGroup(this, type);
                this.state = State.IN_ROW_GROUP;
                break;
            }
            default: {
                this.suppressedStarts = 1;
            }
        }
    }

    void endRowGroup() throws SAXException {
        if (this.needSuppressEnd()) {
            return;
        }
        switch (this.state) {
            case IN_ROW_GROUP: {
                this.current.end();
                this.current = null;
                this.state = State.IN_TABLE_AT_POTENTIAL_ROW_GROUP_START;
                break;
            }
            default: {
                throw new IllegalStateException("Bug!");
            }
        }
    }

    void startRow() {
        if (this.needSuppressStart()) {
            return;
        }
        switch (this.state) {
            case IN_TABLE_AT_START: 
            case IN_TABLE_COLS_SEEN: 
            case IN_TABLE_AT_POTENTIAL_ROW_GROUP_START: {
                this.current = new RowGroup(this, null);
            }
            case IN_IMPLICIT_ROW_GROUP: {
                this.state = State.IN_ROW_IN_IMPLICIT_ROW_GROUP;
                break;
            }
            case IN_ROW_GROUP: {
                this.state = State.IN_ROW_IN_ROW_GROUP;
                break;
            }
            default: {
                this.suppressedStarts = 1;
                return;
            }
        }
        this.currentColRange = this.first;
        this.previousColRange = null;
        this.current.startRow();
    }

    void endRow() throws SAXException {
        if (this.needSuppressEnd()) {
            return;
        }
        switch (this.state) {
            case IN_ROW_IN_ROW_GROUP: {
                this.state = State.IN_ROW_GROUP;
                break;
            }
            case IN_ROW_IN_IMPLICIT_ROW_GROUP: {
                this.state = State.IN_IMPLICIT_ROW_GROUP;
                break;
            }
            default: {
                throw new IllegalStateException("Bug!");
            }
        }
        this.current.endRow();
    }

    void startCell(boolean header, Attributes attributes) throws SAXException {
        if (this.needSuppressStart()) {
            return;
        }
        switch (this.state) {
            case IN_ROW_IN_ROW_GROUP: {
                this.state = State.IN_CELL_IN_ROW_GROUP;
                break;
            }
            case IN_ROW_IN_IMPLICIT_ROW_GROUP: {
                this.state = State.IN_CELL_IN_IMPLICIT_ROW_GROUP;
                break;
            }
            default: {
                this.suppressedStarts = 1;
                return;
            }
        }
        if (header) {
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                String val;
                if (!"ID".equals(attributes.getType(i)) || "".equals(val = attributes.getValue(i))) continue;
                this.headerIds.add(val);
            }
        }
        String[] headers = AttributeUtil.split(attributes.getValue("", "headers"));
        Cell cell = new Cell(Math.abs(AttributeUtil.parsePositiveInteger(attributes.getValue("", "colspan"))), Math.abs(AttributeUtil.parseNonNegativeInteger(attributes.getValue("", "rowspan"))), headers, header, this.owner.getDocumentLocator(), this.owner.getErrorHandler());
        if (headers.length > 0) {
            this.cellsReferringToHeaders.add(cell);
        }
        this.current.cell(cell);
    }

    void endCell() {
        if (this.needSuppressEnd()) {
            return;
        }
        switch (this.state) {
            case IN_CELL_IN_ROW_GROUP: {
                this.state = State.IN_ROW_IN_ROW_GROUP;
                break;
            }
            case IN_CELL_IN_IMPLICIT_ROW_GROUP: {
                this.state = State.IN_ROW_IN_IMPLICIT_ROW_GROUP;
                break;
            }
            default: {
                throw new IllegalStateException("Bug!");
            }
        }
    }

    void startColGroup(int span) {
        if (this.needSuppressStart()) {
            return;
        }
        switch (this.state) {
            case IN_TABLE_AT_START: {
                this.hardWidth = true;
                this.columnCount = 0;
            }
            case IN_TABLE_COLS_SEEN: {
                this.pendingColGroupSpan = span;
                this.state = State.IN_COLGROUP;
                break;
            }
            default: {
                this.suppressedStarts = 1;
            }
        }
    }

    void endColGroup() {
        if (this.needSuppressEnd()) {
            return;
        }
        switch (this.state) {
            case IN_COLGROUP: {
                if (this.pendingColGroupSpan != 0) {
                    int right = this.columnCount + Math.abs(this.pendingColGroupSpan);
                    LocatorImpl locator = new LocatorImpl(this.owner.getDocumentLocator());
                    ColumnRange colRange = new ColumnRange("colgroup", locator, this.columnCount, right);
                    this.appendColumnRange(colRange);
                    this.columnCount = right;
                }
                this.realColumnCount = this.columnCount;
                this.state = State.IN_TABLE_COLS_SEEN;
                break;
            }
            default: {
                throw new IllegalStateException("Bug!");
            }
        }
    }

    void startCol(int span) throws SAXException {
        if (this.needSuppressStart()) {
            return;
        }
        switch (this.state) {
            case IN_TABLE_AT_START: {
                this.hardWidth = true;
                this.columnCount = 0;
            }
            case IN_TABLE_COLS_SEEN: {
                this.state = State.IN_COL_IN_IMPLICIT_GROUP;
                break;
            }
            case IN_COLGROUP: {
                if (this.pendingColGroupSpan > 0) {
                    this.warn("A col element causes a span attribute with value " + this.pendingColGroupSpan + " to be ignored on the parent colgroup.");
                }
                this.pendingColGroupSpan = 0;
                this.state = State.IN_COL_IN_COLGROUP;
                break;
            }
            default: {
                this.suppressedStarts = 1;
                return;
            }
        }
        int right = this.columnCount + Math.abs(span);
        LocatorImpl locator = new LocatorImpl(this.owner.getDocumentLocator());
        ColumnRange colRange = new ColumnRange("col", locator, this.columnCount, right);
        this.appendColumnRange(colRange);
        this.realColumnCount = this.columnCount = right;
    }

    private void appendColumnRange(ColumnRange colRange) {
        if (this.last == null) {
            this.first = colRange;
            this.last = colRange;
        } else {
            this.last.setNext(colRange);
            this.last = colRange;
        }
    }

    void warn(String message) throws SAXException {
        this.owner.warn(message);
    }

    void err(String message) throws SAXException {
        this.owner.err(message);
    }

    void endCol() {
        if (this.needSuppressEnd()) {
            return;
        }
        switch (this.state) {
            case IN_COL_IN_IMPLICIT_GROUP: {
                this.state = State.IN_TABLE_COLS_SEEN;
                break;
            }
            case IN_COL_IN_COLGROUP: {
                this.state = State.IN_COLGROUP;
                break;
            }
            default: {
                throw new IllegalStateException("Bug!");
            }
        }
    }

    void end() throws SAXException {
        switch (this.state) {
            case IN_IMPLICIT_ROW_GROUP: {
                this.current.end();
                this.current = null;
                break;
            }
            case IN_TABLE_AT_START: 
            case IN_TABLE_COLS_SEEN: 
            case IN_TABLE_AT_POTENTIAL_ROW_GROUP_START: {
                break;
            }
            default: {
                throw new IllegalStateException("Bug!");
            }
        }
        for (Cell cell : this.cellsReferringToHeaders) {
            String[] headings = cell.getHeadings();
            for (int i = 0; i < headings.length; ++i) {
                String heading = headings[i];
                if (this.headerIds.contains(heading)) continue;
                cell.err("The \u201cheaders\u201d attribute on the element \u201c" + cell.elementName() + "\u201d refers to the ID \u201c" + heading + "\u201d, but there is no \u201cth\u201d element with that ID in the same table.");
            }
        }
        for (ColumnRange colRange = this.first; colRange != null; colRange = colRange.getNext()) {
            if (colRange.isSingleCol()) {
                this.owner.getErrorHandler().error(new SAXParseException("Table column " + colRange + " established by element \u201c" + colRange.getElement() + "\u201d has no cells beginning in it.", colRange.getLocator()));
                continue;
            }
            this.owner.getErrorHandler().error(new SAXParseException("Table columns in range " + colRange + " established by element \u201c" + colRange.getElement() + "\u201d have no cells beginning in them.", colRange.getLocator()));
        }
    }

    int getColumnCount() {
        return this.columnCount;
    }

    void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    boolean isHardWidth() {
        return this.hardWidth;
    }

    void cell(Cell cell) {
        int left = cell.getLeft();
        int right = cell.getRight();
        if (right > this.realColumnCount) {
            if (left == this.realColumnCount) {
                if (left + 1 != right) {
                    this.appendColumnRange(new ColumnRange(cell.elementName(), cell, left + 1, right));
                }
                this.realColumnCount = right;
                return;
            }
            this.appendColumnRange(new ColumnRange(cell.elementName(), cell, this.realColumnCount, right));
            this.realColumnCount = right;
        }
        while (this.currentColRange != null) {
            int hit = this.currentColRange.hits(left);
            if (hit == 0) {
                ColumnRange newRange = this.currentColRange.removeColumn(left);
                if (newRange == null) {
                    if (this.previousColRange != null) {
                        this.previousColRange.setNext(this.currentColRange.getNext());
                    }
                    if (this.first == this.currentColRange) {
                        this.first = this.currentColRange.getNext();
                    }
                    if (this.last == this.currentColRange) {
                        this.last = this.previousColRange;
                    }
                    this.currentColRange = this.currentColRange.getNext();
                } else {
                    if (this.last == this.currentColRange) {
                        this.last = newRange;
                    }
                    this.currentColRange = newRange;
                }
                return;
            }
            if (hit == -1) {
                return;
            }
            if (hit != 1) continue;
            this.previousColRange = this.currentColRange;
            this.currentColRange = this.currentColRange.getNext();
        }
    }

    private static enum State {
        IN_TABLE_AT_START,
        IN_TABLE_AT_POTENTIAL_ROW_GROUP_START,
        IN_COLGROUP,
        IN_COL_IN_COLGROUP,
        IN_COL_IN_IMPLICIT_GROUP,
        IN_ROW_GROUP,
        IN_ROW_IN_ROW_GROUP,
        IN_CELL_IN_ROW_GROUP,
        IN_ROW_IN_IMPLICIT_ROW_GROUP,
        IN_IMPLICIT_ROW_GROUP,
        IN_CELL_IN_IMPLICIT_ROW_GROUP,
        IN_TABLE_COLS_SEEN;

    }
}

