/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy getFileRevision(VCSFileProxy base, String revision, ProgressMonitor pm) throws IOException {
        if ("-1".equals(revision)) {
            return null;
        }
        VCSFileProxy repository = Git.getInstance().getRepositoryRoot(base);
        if ("CURRENT".equals(revision)) {
            return base.exists() ? base : null;
        }
        VCSFileProxySupport.getTempFolder((VCSFileProxy)base, (boolean)true);
        FileObject tempFolder = VCSFileProxySupport.getFileSystem((VCSFileProxy)base).getTempFolder();
        VCSFileProxy tempFile = VCSFileProxySupport.createTempFile((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)tempFolder), (String)("nb-git-" + base.getName()), null, (boolean)true);
        GitClient client = null;
        try {
            boolean result;
            client = Git.getInstance().getClient(repository);
            try (OutputStream fos = VCSFileProxySupport.getOutputStream((VCSFileProxy)tempFile);){
                result = "INDEX".equals(revision) ? client.catIndexEntry(base, 0, fos, pm) : client.catFile(base, revision, fos, pm);
            }
            if (!result) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFile);
                tempFile = null;
            }
        }
        catch (FileNotFoundException ex) {
            VCSFileProxySupport.delete((VCSFileProxy)tempFile);
            tempFile = null;
        }
        catch (GitException.MissingObjectException ex) {
            VCSFileProxySupport.delete((VCSFileProxy)tempFile);
            tempFile = null;
        }
        catch (GitException ex) {
            throw new IOException(ex);
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return tempFile;
    }
}

