/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.shelve;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.ShelveChangesSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ShelveChangesAction
extends ContextAction {
    private static ShelveChangesActionsRegistry.ShelveChangesActionProvider ACTION_PROVIDER;

    @Override
    public boolean enable(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(ctx) || !Mercurial.getInstance().getFileStatusCache().containsFileOfStatus(ctx, 6612, true)) {
            return false;
        }
        return super.enable(nodes);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_ShelveChanges_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        VCSFileProxy root = HgUtils.getRootFile(ctx);
        if (root == null) {
            Mercurial.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        HgShelveChangesSupport supp = new HgShelveChangesSupport(root);
        if (supp.open()) {
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
            supp.startAsync(rp, root, ctx);
        }
    }

    public static synchronized ShelveChangesActionsRegistry.ShelveChangesActionProvider getProvider() {
        if (ACTION_PROVIDER == null) {
            ACTION_PROVIDER = new ShelveChangesActionsRegistry.ShelveChangesActionProvider(){

                public Action getAction() {
                    SystemAction a = SystemAction.get(ShelveChangesAction.class);
                    Utils.setAcceleratorBindings((String)"Actions/MercurialRemote", (Action[])new Action[]{a});
                    return a;
                }
            };
        }
        return ACTION_PROVIDER;
    }

    private static class HgShelveChangesSupport
    extends ShelveChangesSupport {
        private HgProgressSupport support;
        private OutputLogger logger;
        private Set<VCSFileProxy> filteredRoots;
        private final JPanel optionsPanel;
        private final JCheckBox doBackupChxBox;
        private final JCheckBox doPurgeChxBox;
        private boolean doBackup;
        private boolean doPurge;
        private final VCSFileProxy root;

        public HgShelveChangesSupport(VCSFileProxy root) {
            this.root = root;
            this.doBackupChxBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.doBackupChxBox, (String)NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doBackupChxBox.text"));
            this.doBackupChxBox.setToolTipText(NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doBackupChxBox.desc"));
            this.doBackupChxBox.getAccessibleContext().setAccessibleDescription(this.doBackupChxBox.getToolTipText());
            this.doBackupChxBox.setSelected(HgModuleConfig.getDefault(root).getBackupOnRevertModifications());
            this.doPurgeChxBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.doPurgeChxBox, (String)NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doPurgeChxBox.text"));
            this.doPurgeChxBox.setToolTipText(NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doPurgeChxBox.desc"));
            this.doPurgeChxBox.getAccessibleContext().setAccessibleDescription(this.doPurgeChxBox.getToolTipText());
            this.doPurgeChxBox.setSelected(HgModuleConfig.getDefault(root).isRemoveNewFilesOnRevertModifications());
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            this.optionsPanel.add(this.doBackupChxBox);
            this.optionsPanel.add(this.doPurgeChxBox);
        }

        protected void exportPatch(File toFile, File commonParent) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void postExportCleanup() {
            Map<VCSFileProxy, Set<VCSFileProxy>> sorted = HgUtils.sortUnderRepository(this.filteredRoots);
            for (Map.Entry<VCSFileProxy, Set<VCSFileProxy>> e : sorted.entrySet()) {
                VCSFileProxy root = e.getKey();
                Set<VCSFileProxy> roots = e.getValue();
                if (roots.isEmpty()) continue;
                this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.reverting", (Object)root.getName()));
                RevertModificationsAction.performRevert(root, null, roots.toArray(new VCSFileProxy[roots.size()]), this.doBackup, this.doPurge, this.logger);
            }
        }

        protected boolean isCanceled() {
            return this.support == null ? false : this.support.isCanceled();
        }

        private void startAsync(RequestProcessor rp, VCSFileProxy root, final VCSContext context) {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    HgShelveChangesSupport.this.logger = this.getLogger();
                    HgShelveChangesSupport.this.filteredRoots = new HashSet<VCSFileProxy>(Arrays.asList(HgUtils.getModifiedFiles(context, 6612, true)));
                }
            };
            this.support.start(rp, root, NbBundle.getMessage(ShelveChangesAction.class, (String)"LBL_ShelveChanges_Progress"));
        }

        private boolean open() {
            boolean retval = this.prepare(this.optionsPanel, "org.netbeans.modules.mercurial.remote.ui.shelve.ShelveChangesPanel");
            if (retval) {
                this.doBackup = this.doBackupChxBox.isSelected();
                this.doPurge = this.doPurgeChxBox.isSelected();
                HgModuleConfig.getDefault(this.root).setBackupOnRevertModifications(this.doBackup);
                HgModuleConfig.getDefault(this.root).setRemoveNewFilesOnRevertModifications(this.doPurge);
            }
            return retval;
        }
    }
}

