/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.config.HgConfigFiles;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class HgRepositoryContextCache {
    private Map<VCSFileProxy, Map<String, String>> rootToDefaultPaths;
    private static HgRepositoryContextCache instance;

    private HgRepositoryContextCache() {
    }

    public static synchronized HgRepositoryContextCache getInstance() {
        if (instance == null) {
            instance = new HgRepositoryContextCache();
        }
        return instance;
    }

    public synchronized void reset() {
        this.getRootToDefaultPaths().clear();
    }

    public synchronized String getPullDefault(VCSFileProxy file) {
        VCSFileProxy repoRoot = Mercurial.getInstance().getRepositoryRoot(file);
        if (repoRoot == null) {
            return null;
        }
        Map<String, String> paths = this.getPaths(repoRoot);
        return paths.get("default");
    }

    public synchronized String getPushDefault(VCSFileProxy file) {
        VCSFileProxy repoRoot = Mercurial.getInstance().getRepositoryRoot(file);
        if (repoRoot == null) {
            return null;
        }
        Map<String, String> paths = this.getPaths(repoRoot);
        return paths.get("default-push");
    }

    public String getPathValue(VCSFileProxy root, String path) {
        VCSFileProxy repoRoot = Mercurial.getInstance().getRepositoryRoot(root);
        if (repoRoot == null) {
            return null;
        }
        Map<String, String> paths = this.getPaths(repoRoot);
        return paths.get(path);
    }

    public Map<String, String> getPathValues(VCSFileProxy root) {
        VCSFileProxy repoRoot = Mercurial.getInstance().getRepositoryRoot(root);
        if (repoRoot == null) {
            return Collections.emptyMap();
        }
        Map<String, String> paths = this.getPaths(repoRoot);
        return new HashMap<String, String>(paths);
    }

    private Map<String, String> getPaths(VCSFileProxy repoRoot) {
        Map<VCSFileProxy, Map<String, String>> map = this.getRootToDefaultPaths();
        Map<String, String> paths = map.get(repoRoot);
        if (paths == null) {
            HgConfigFiles config = new HgConfigFiles(repoRoot);
            String pull = config.getDefaultPull(true);
            String push = config.getDefaultPush(true);
            paths = new HashMap<String, String>();
            paths.put("default", pull);
            paths.put("default-push", push);
            for (Map.Entry<Object, Object> e : config.getProperties("paths").entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (key == null || value == null || key.isEmpty() || value.isEmpty()) continue;
                paths.put(key.trim(), value.trim());
            }
            map.put(repoRoot, paths);
        }
        return paths;
    }

    private Map<VCSFileProxy, Map<String, String>> getRootToDefaultPaths() {
        if (this.rootToDefaultPaths == null) {
            this.rootToDefaultPaths = new HashMap<VCSFileProxy, Map<String, String>>();
        }
        return this.rootToDefaultPaths;
    }
}

