/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import javax.swing.UIManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LevelOfDetailsWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.Bundle;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

public class EdgeWidget
extends ConnectionWidget {
    public static final int DISABLED = 0;
    public static final int GRAYED = 1;
    public static final int REGULAR = 2;
    public static final int HIGHLIGHTED = 3;
    public static final int HIGHLIGHTED_PRIMARY = 4;
    private static float[] hsbVals = new float[3];
    private ArtifactGraphEdge edge;
    private int state = 2;
    private boolean isConflict;
    private int edgeConflictType;
    private LabelWidget conflictVersion;
    private Widget versionW;
    private Stroke origStroke;

    public EdgeWidget(DependencyGraphScene scene, ArtifactGraphEdge edge) {
        super((Scene)scene);
        this.edge = edge;
        this.origStroke = this.getStroke();
        this.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.isConflict = edge.getTarget().getState() == 2;
        this.edgeConflictType = this.getConflictType();
        this.updateVersionW(this.isConflict);
    }

    private void updateVersionW(boolean isConflict) {
        DependencyGraphScene scene = (DependencyGraphScene)this.getScene();
        ArtifactGraphNode targetNode = scene.getGraphNodeRepresentant(this.edge.getTarget());
        if (targetNode == null) {
            return;
        }
        int includedConflictType = targetNode.getConflictType();
        if (this.versionW == null) {
            if (isConflict || includedConflictType != 0) {
                Color c;
                this.versionW = new LevelOfDetailsWidget((Scene)scene, 0.5, 0.7, Double.MAX_VALUE, Double.MAX_VALUE);
                this.conflictVersion = new LabelWidget((Scene)scene, this.edge.getTarget().getArtifact().getVersion());
                if (isConflict && (c = EdgeWidget.getConflictColor(this.edgeConflictType)) != null) {
                    this.conflictVersion.setForeground(c);
                }
                this.versionW.addChild((Widget)this.conflictVersion);
                this.addChild(this.versionW);
                this.setConstraint(this.versionW, LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT, 0.5f);
            }
        } else if (!isConflict && includedConflictType == 0 && this.versionW.getParentWidget() == this) {
            this.removeChild(this.versionW);
        }
    }

    public void setState(int state) {
        this.state = state;
        this.updateAppearance(((DependencyGraphScene)this.getScene()).isAnimated());
    }

    void updateReadableZoom() {
        if (this.state == 3 || this.state == 4) {
            this.updateAppearance(false);
        }
    }

    void modelChanged() {
        this.edgeConflictType = this.getConflictType();
        boolean bl = this.isConflict = this.edge.getTarget().getState() == 2;
        if (this.isConflict && this.edgeConflictType == 0) {
            this.isConflict = false;
        }
        this.updateVersionW(this.isConflict);
        this.updateAppearance(((DependencyGraphScene)this.getScene()).isAnimated());
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void updateAppearance(boolean animated) {
        Color conflictC;
        Color activeC;
        Color inactiveC = UIManager.getColor("textInactiveText");
        if (inactiveC == null) {
            inactiveC = Color.LIGHT_GRAY;
        }
        if ((activeC = UIManager.getColor("textText")) == null) {
            activeC = Color.BLACK;
        }
        if ((conflictC = EdgeWidget.getConflictColor(this.edgeConflictType)) == null) {
            conflictC = activeC;
        }
        Stroke stroke = this.origStroke;
        Color c = activeC;
        switch (this.state) {
            case 2: {
                c = this.edge.isPrimary() ? EdgeWidget.middleColor(activeC, inactiveC) : (this.isConflict ? conflictC : inactiveC);
                break;
            }
            case 1: {
                c = this.isConflict ? EdgeWidget.deriveColor(conflictC, 0.7f) : inactiveC;
                break;
            }
            case 4: {
                stroke = new BasicStroke(3.0f);
            }
            case 3: {
                Color color = c = this.isConflict ? conflictC : activeC;
            }
        }
        if (this.state != 0) {
            StringBuilder sb = new StringBuilder("<html>");
            if (this.isConflict) {
                DependencyGraphScene grScene = (DependencyGraphScene)this.getScene();
                DependencyNode includedDepN = grScene.getGraphNodeRepresentant(this.edge.getTarget()).getArtifact();
                if (includedDepN == null) {
                    return;
                }
                DependencyNode parent = includedDepN.getParent();
                String version = includedDepN.getArtifact().getVersion();
                String requester = parent != null ? parent.getArtifact().getArtifactId() : "???";
                String confText = this.edgeConflictType == 2 ? Bundle.TIP_VersionConflict(version, requester) : Bundle.TIP_VersionWarning(version, requester);
                this.conflictVersion.setToolTipText(confText);
                sb.append(confText);
                sb.append("<br>");
            }
            sb.append("<i>");
            if (this.edge.isPrimary()) {
                sb.append(Bundle.TIP_Primary());
            } else {
                sb.append(Bundle.TIP_Secondary());
            }
            sb.append("</i>");
            sb.append("</html>");
            this.setToolTipText(sb.toString());
        } else {
            this.setToolTipText(null);
        }
        if (this.conflictVersion != null) {
            this.conflictVersion.setForeground(c);
            Font origF = this.getScene().getDefaultFont();
            this.conflictVersion.setFont(this.state == 3 || this.state == 4 ? ArtifactWidget.getReadable(this.getScene(), origF) : origF);
        }
        this.setVisible(this.state != 0);
        this.setStroke(stroke);
        DependencyGraphScene grScene = (DependencyGraphScene)this.getScene();
        if (animated) {
            grScene.getSceneAnimator().animateForegroundColor((Widget)this, c);
        } else {
            this.setForeground(c);
        }
    }

    private int getConflictType() {
        DefaultArtifactVersion includedV;
        ArtifactGraphNode included = ((DependencyGraphScene)this.getScene()).getGraphNodeRepresentant(this.edge.getTarget());
        if (included == null) {
            return 0;
        }
        DefaultArtifactVersion edgeV = new DefaultArtifactVersion(this.edge.getTarget().getArtifact().getVersion());
        int ret = edgeV.compareTo((ArtifactVersion)(includedV = new DefaultArtifactVersion(included.getArtifact().getArtifact().getVersion())));
        return ret > 0 ? 2 : (ret < 0 ? 1 : 0);
    }

    private static Color getConflictColor(int conflictType) {
        return conflictType == 2 ? ArtifactWidget.CONFLICT : (conflictType == 1 ? ArtifactWidget.WARNING : null);
    }

    static Color deriveColor(Color c, float saturationR) {
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsbVals);
        EdgeWidget.hsbVals[1] = Math.min(1.0f, hsbVals[1] * saturationR);
        return Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2]);
    }

    private static Color middleColor(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }
}

