/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.text.completion.DefaultContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

final class SyntaxQueryHelper {
    public static final int COMPLETION_TYPE_UNKNOWN = 0;
    public static final int COMPLETION_TYPE_ATTRIBUTE = 1;
    public static final int COMPLETION_TYPE_VALUE = 2;
    public static final int COMPLETION_TYPE_ELEMENT = 3;
    public static final int COMPLETION_TYPE_ENTITY = 4;
    public static final int COMPLETION_TYPE_NOTATION = 5;
    public static final int COMPLETION_TYPE_DTD = 6;
    private TokenItem token = null;
    private String preText = "";
    private int erase = 0;
    private int tunedOffset = 0;
    private SyntaxElement element;
    private int completionType = 0;
    private boolean tokenBoundary;
    private DefaultContext ctx = new DefaultContext();

    public SyntaxQueryHelper(XMLSyntaxSupport sup, int offset) throws BadLocationException, IllegalStateException {
        this.tunedOffset = offset;
        this.token = sup.getPreviousToken(this.tunedOffset);
        if (this.token == null) {
            throw new BadLocationException("No token found at current position", offset);
        }
        this.tokenBoundary = this.token.getOffset() + this.token.getImage().length() == this.tunedOffset;
        int itemOffset = this.token.getOffset();
        this.preText = "";
        this.erase = 0;
        int eraseRight = 0;
        int id = this.token.getTokenID().getNumericID();
        if (!this.tokenBoundary) {
            this.preText = this.token.getImage().substring(0, this.tunedOffset - this.token.getOffset());
            if ("".equals(this.preText)) {
                throw new IllegalStateException("Cannot get token prefix at " + this.tunedOffset);
            }
            if (sup.lastTypedChar() != '<' && sup.lastTypedChar() != '&') {
                switch (id) {
                    case 4: 
                    case 5: 
                    case 11: {
                        int i = this.token.getImage().length();
                        int tail = i - (this.tunedOffset - itemOffset);
                        this.tunedOffset += tail;
                        eraseRight = tail;
                    }
                }
            }
        } else {
            switch (id) {
                case 1: 
                case 4: 
                case 5: 
                case 11: 
                case 15: {
                    this.preText = this.token.getImage();
                }
            }
        }
        switch (id) {
            case 4: {
                this.erase = this.preText.length() - 1 + eraseRight;
                break;
            }
            case 11: {
                this.erase = this.preText.length() + -1 + eraseRight;
                break;
            }
            case 5: {
                this.erase = this.preText.length() + eraseRight;
                break;
            }
            case 7: {
                this.erase = this.preText.length();
                if (this.erase <= 0 || this.preText.charAt(0) != '\'' && this.preText.charAt(0) != '\"') break;
                --this.erase;
            }
        }
        this.element = sup.getElementChain(this.tunedOffset);
        if (this.element == null) {
            throw new IllegalStateException("There exists a token therefore a syntax element must exist at " + offset + ", too.");
        }
        this.completionType = this.element instanceof SyntaxNode && ((SyntaxNode)this.element).getNodeType() != 10 ? this.initContext() : 6;
    }

    private int initContext() {
        int id = this.token.getTokenID().getNumericID();
        SyntaxNode syntaxNode = (SyntaxNode)this.element;
        switch (id) {
            case 1: {
                if (this.preText.endsWith("<") || this.preText.endsWith("</")) {
                    this.ctx.init(syntaxNode, "");
                    return 3;
                }
                if (this.preText.startsWith("&")) {
                    this.ctx.init(syntaxNode, this.preText.substring(1));
                    return 4;
                }
                this.ctx.init(syntaxNode, this.preText);
                return 2;
            }
            case 4: {
                if (StartTag.class.equals(syntaxNode.getClass()) || EmptyTag.class.equals(syntaxNode.getClass())) {
                    if (this.preText.equals("")) {
                        if (this.token.getImage().endsWith(">")) {
                            this.ctx.init(syntaxNode, this.preText);
                            return 2;
                        }
                        this.ctx.init(syntaxNode, this.preText);
                        return 3;
                    }
                    if (this.preText.endsWith("/>")) {
                        this.ctx.init(syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.endsWith(">")) {
                        this.ctx.init(syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.startsWith("</")) {
                        this.ctx.init(syntaxNode, this.preText.substring(2));
                        return 3;
                    }
                    if (!this.preText.startsWith("<")) break;
                    this.ctx.init(syntaxNode, this.preText.substring(1));
                    return 3;
                }
                if (EndTag.class.equals(syntaxNode.getClass()) && this.preText.startsWith("</")) {
                    this.ctx.init(syntaxNode, this.preText.substring(2));
                    return 3;
                }
                if (!"".equals(this.preText) || !this.token.getImage().endsWith(">")) break;
                this.ctx.init(syntaxNode, this.preText);
                return 2;
            }
            case 7: {
                if (this.preText.endsWith("&")) {
                    this.ctx.init(syntaxNode, "");
                    return 4;
                }
                if ("".equals(this.preText)) {
                    String image = this.token.getImage();
                    char ch = image.charAt(image.length() - 1);
                    if (ch == '\'' || ch == '\"') {
                        if (image.charAt(0) == ch && image.length() > 1) {
                            return 0;
                        }
                        boolean closing = false;
                        for (TokenItem prev = this.token.getPrevious(); prev != null; prev = prev.getPrevious()) {
                            int tid = prev.getTokenID().getNumericID();
                            if (tid == 7) {
                                closing = true;
                                break;
                            }
                            if (tid != 11) break;
                        }
                        if (closing) break;
                        this.ctx.init(syntaxNode, this.preText);
                        return 2;
                    }
                    this.ctx.init(syntaxNode, this.preText);
                    return 2;
                }
                NamedNodeMap attrs = syntaxNode.getAttributes();
                int maxOffsetLessThanCurrent = -1;
                AttrImpl curAttrNode = null;
                for (int ind = 0; ind < attrs.getLength(); ++ind) {
                    AttrImpl attr = (AttrImpl)attrs.item(ind);
                    int attrTokOffset = attr.getFirstToken().getOffset();
                    if (attrTokOffset <= maxOffsetLessThanCurrent || attrTokOffset >= this.token.getOffset()) continue;
                    maxOffsetLessThanCurrent = attrTokOffset;
                    curAttrNode = attr;
                }
                if (this.preText.length() > 0) {
                    this.preText = this.preText.substring(1);
                }
                if (curAttrNode != null) {
                    this.ctx.init(curAttrNode, this.preText);
                } else {
                    this.ctx.init(syntaxNode, this.preText);
                }
                return 2;
            }
            case 6: {
                if (!"".equals(this.preText) || !"=".equals(this.token.getImage())) break;
                this.ctx.init(syntaxNode, "");
                return 2;
            }
            case 2: {
                if ((StartTag.class.equals(syntaxNode.getClass()) || EmptyTag.class.equals(syntaxNode.getClass())) && !this.token.getImage().startsWith("/")) {
                    this.ctx.init((Element)((Object)syntaxNode), "");
                    return 1;
                }
                return 0;
            }
            case 5: {
                if (!StartTag.class.equals(syntaxNode.getClass()) && !EmptyTag.class.equals(syntaxNode.getClass())) break;
                Tag tag = (Tag)syntaxNode;
                NamedNodeMap nnm = tag.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    AttrImpl attrNode = (AttrImpl)nnm.item(i);
                    if (attrNode.getFirstToken().getOffset() != this.token.getOffset()) continue;
                    this.ctx.init(attrNode, this.preText);
                }
                if (!this.ctx.isInitialized()) {
                    this.ctx.init((Element)((Object)syntaxNode), this.preText);
                }
                return 1;
            }
            case 11: {
                if (this.preText.startsWith("&#")) {
                    return 0;
                }
                if (this.preText.endsWith(";")) {
                    this.ctx.init(syntaxNode, "");
                    return 2;
                }
                if (this.preText.startsWith("&")) {
                    this.ctx.init(syntaxNode, this.preText.substring(1));
                    return 4;
                }
                if (!"".equals(this.preText) || !this.token.getImage().endsWith(";")) break;
                this.ctx.init(syntaxNode, this.preText);
                return 2;
            }
        }
        return 0;
    }

    public HintContext getContext() {
        if (this.completionType != 0 && this.completionType != 6) {
            return this.ctx;
        }
        return null;
    }

    public TokenItem getToken() {
        return this.token;
    }

    public String getPreText() {
        return this.preText;
    }

    public int getEraseCount() {
        return this.erase;
    }

    public int getOffset() {
        return this.tunedOffset;
    }

    public SyntaxElement getSyntaxElement() {
        return this.element;
    }

    public int getCompletionType() {
        return this.completionType;
    }

    public boolean isBoundary() {
        return this.tokenBoundary;
    }
}

