/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectWithCache;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class RemotePlainFile
extends RemoteFileObjectWithCache {
    private static final int REFRESH_TIMEOUT = Integer.getInteger("remote.plain.file.refresh.timeout", 5000);

    RemotePlainFile(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteDirectory parent, String remotePath, File cache) {
        super(wrapper, fileSystem, execEnv, parent, remotePath, cache);
    }

    @Override
    public final RemoteFileObject[] getChildren() {
        return new RemoteFileObject[0];
    }

    @Override
    public final boolean isFolder() {
        return false;
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public final RemoteFileObject getFileObject(String name, String ext, @NonNull Set<String> antiLoop) {
        return null;
    }

    @Override
    public RemoteFileObject getFileObject(String relativePath, @NonNull Set<String> antiLoop) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (!(relativePath.equals(".") || relativePath.contains("..") || relativePath.contains("/"))) {
            return null;
        }
        RemoteFileObject res = this.getOwnerFileObject();
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        while (res != null && st.hasMoreTokens()) {
            String nameExt = st.nextToken();
            if (nameExt.equals("..")) {
                res = res.getParent();
                continue;
            }
            if (nameExt.equals(".")) continue;
            res = res.getFileObject(nameExt, antiLoop);
        }
        return res;
    }

    private RemoteDirectory getParentImpl() {
        return (RemoteDirectory)this.getParent();
    }

    @Override
    public InputStream getInputStream(boolean checkLock) throws FileNotFoundException {
        try {
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST) && ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment()) && !this.getCache().exists() && this.getOwnerFileObject().isMimeResolving()) {
                new Exception("Shouldn't come here in MIME resolved mode " + this).printStackTrace(System.err);
            }
            if (!checkLock) {
                File cache = this.getCache();
                if (cache.exists()) {
                    return new FileInputStream(cache);
                }
                final File tmpCache = File.createTempFile(this.getName().length() < 3 ? this.getName() + "___" : this.getName(), this.getExt());
                StringWriter errorWriter = new StringWriter();
                Future task = CommonTasksSupport.downloadFile((String)this.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)tmpCache.getAbsolutePath(), (Writer)errorWriter);
                int rc = (Integer)task.get();
                if (rc != 0) {
                    throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CanNotDownload", (Object)this.getDisplayName(tmpCache.getAbsolutePath()), (Object)errorWriter.toString()));
                }
                return new InputStreamWrapper(new FileInputStream(tmpCache), new Runnable(){

                    @Override
                    public void run() {
                        tmpCache.delete();
                    }
                });
            }
            this.getLockSupport().tryReadLock(this);
            RemoteFileSystemUtils.getCanonicalParent(this).ensureChildSync(this);
            return new InputStreamWrapper(new FileInputStream(this.getCache()), new Runnable(){

                @Override
                public void run() {
                    RemotePlainFile.this.getLockSupport().readUnlock(RemotePlainFile.this);
                }
            });
        }
        catch (ConnectException | CancellationException ex) {
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ex) {
            throw this.newFileNotFoundException(ex);
        }
    }

    private FileNotFoundException newFileNotFoundException(Exception cause) {
        return RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_DoesNotExistXX", (Object)cause.getLocalizedMessage()), cause);
    }

    @Override
    public RemoteFileObject createDataImpl(String name, String ext, RemoteFileObjectBase orig) throws IOException {
        throw RemoteExceptions.createIOException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_PlainFileChildren", (Object)this.getDisplayName()));
    }

    @Override
    public RemoteFileObject createFolderImpl(String name, RemoteFileObjectBase orig) throws IOException {
        throw RemoteExceptions.createIOException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_PlainFileChildren", (Object)this.getDisplayName()));
    }

    @Override
    protected FileLock lockImpl(RemoteFileObjectBase orig) throws IOException {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor = null;
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null && !this.canWriteImpl(orig)) {
            throw RemoteExceptions.createIOException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_CannotLockReadOnlyFile", (Object)this.getDisplayName()));
        }
        FileLock lock = super.lockImpl(orig);
        if (interceptor != null) {
            this.getFileSystem().setInsideVCS(true);
            try {
                interceptor.fileLocked(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()));
            }
            catch (IOException ex) {
                lock.releaseLock();
                throw ex;
            }
            finally {
                this.getFileSystem().setInsideVCS(false);
            }
        }
        return lock;
    }

    @Override
    protected void postDeleteOrCreateChild(RemoteFileObject child, DirEntryList entryList) {
        RemoteLogger.getInstance().log(Level.WARNING, "postDeleteChild is called on {0}", this.getClass().getSimpleName());
    }

    @Override
    protected DirEntryList deleteImpl(FileLock lock) throws IOException {
        return RemoteFileSystemTransport.delete(this.getExecutionEnvironment(), this.getPath(), false);
    }

    @Override
    protected void renameChild(FileLock lock, RemoteFileObjectBase toRename, String newNameExt, RemoteFileObjectBase orig) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteLogger.assertTrueInConsole(false, "renameChild is not supported on " + this.getClass() + " path=" + this.getPath(), new Object[0]);
    }

    @Override
    protected OutputStream getOutputStreamImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        try {
            if (!this.isValid()) {
                throw RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_InvalidFO", (Object)this.getDisplayName()));
            }
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor = null;
            if (USE_VCS) {
                interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem());
            }
            this.getLockSupport().tryWriteLock(this);
            return new DelegateOutputStream(interceptor, orig);
        }
        catch (InterruptedException ex) {
            throw RemoteExceptions.createInterruptedIOException(ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected, RemoteFileObjectBase.RefreshMode refreshMode) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        try {
            this.refreshImpl(recursive, antiLoop, expected, refreshMode, REFRESH_TIMEOUT);
        }
        catch (TimeoutException ex) {
            RemoteLogger.info("Timeout {0} ms when refreshing {0}", REFRESH_TIMEOUT, this);
        }
    }

    @Override
    public void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected, RemoteFileObjectBase.RefreshMode refreshMode, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        if (refreshMode != RemoteFileObjectBase.RefreshMode.FROM_PARENT && Boolean.valueOf(System.getProperty("cnd.remote.refresh.plain.file", "true")).booleanValue()) {
            DirEntry newEntry;
            boolean removeCache;
            boolean fireChangedRO;
            boolean updateStat;
            boolean refreshParent;
            DirEntry oldEntry;
            long time;
            block20: {
                time = System.currentTimeMillis();
                oldEntry = this.getParentImpl().getDirEntry(this.getNameExt());
                refreshParent = false;
                updateStat = false;
                fireChangedRO = false;
                removeCache = false;
                newEntry = null;
                try {
                    newEntry = RemoteFileSystemTransport.lstat(this.getExecutionEnvironment(), this.getPath(), timeoutMillis);
                }
                catch (ExecutionException ex) {
                    if (RemoteFileSystemUtils.isFileNotFoundException(ex)) break block20;
                    throw ex;
                }
            }
            if (newEntry == null || oldEntry == null || !oldEntry.isValid()) {
                refreshParent = true;
            } else {
                assert (newEntry.getName().equals(oldEntry.getName()));
                if (oldEntry.isSameType(newEntry)) {
                    if (!newEntry.isSameLastModified(oldEntry)) {
                        updateStat = true;
                        removeCache = true;
                    } else if (newEntry.getSize() != oldEntry.getSize()) {
                        updateStat = true;
                        removeCache = true;
                    } else if (newEntry.getDevice() != oldEntry.getDevice()) {
                        updateStat = true;
                        removeCache = true;
                    } else if (newEntry.getINode() != oldEntry.getINode()) {
                        updateStat = true;
                        removeCache = true;
                    }
                    if (!newEntry.isSameAccess(oldEntry)) {
                        updateStat = true;
                        fireChangedRO = true;
                    }
                } else {
                    refreshParent = true;
                }
            }
            if (refreshParent) {
                this.getParent().refreshImpl(false, antiLoop, expected, refreshMode);
            } else if (updateStat) {
                if (removeCache) {
                    this.getCache().delete();
                }
                this.updateStatAndSendEvents(newEntry, fireChangedRO);
            }
            RemoteLogger.getInstance().log(Level.FINE, "Refreshing {0} took {1} ms", new Object[]{this.getPath(), System.currentTimeMillis() - time});
        }
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.Regular;
    }

    private void updateStatAndSendEvents(DirEntry dirEntry, boolean fireChangedRO) {
        this.getParentImpl().updateStat(this, dirEntry);
        FileEvent ev = new FileEvent((FileObject)this.getOwnerFileObject(), (FileObject)this.getOwnerFileObject(), false, dirEntry.getLastModified().getTime());
        this.getOwnerFileObject().fireFileChangedEvent(this.getListeners(), ev);
        RemoteDirectory parent = this.getParentImpl();
        if (parent != null) {
            ev = new FileEvent((FileObject)parent.getOwnerFileObject(), (FileObject)this.getOwnerFileObject(), false, dirEntry.getLastModified().getTime());
            parent.getOwnerFileObject().fireFileChangedEvent(parent.getListeners(), ev);
            if (fireChangedRO) {
                this.fireReadOnlyChangedEvent();
            }
        }
    }

    private class DelegateOutputStream
    extends OutputStream {
        private final FileOutputStream delegate;
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DelegateOutputStream(FilesystemInterceptorProvider.FilesystemInterceptor interceptor, RemoteFileObjectBase orig) throws IOException {
            if (interceptor != null) {
                try {
                    RemotePlainFile.this.getFileSystem().setInsideVCS(true);
                    interceptor.beforeChange(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()));
                }
                finally {
                    RemotePlainFile.this.getFileSystem().setInsideVCS(false);
                }
            }
            this.delegate = new FileOutputStream(RemotePlainFile.this.getCache());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                String pathToUpload;
                String pathToRename;
                this.delegate.close();
                RemotePlainFile.this.setPendingRemoteDelivery(true);
                if (RemotePlainFile.this.getParent().canWrite()) {
                    pathToRename = RemotePlainFile.this.getPath();
                    pathToUpload = PathUtilities.getDirName((String)pathToRename) + "/#" + PathUtilities.getBaseName((String)pathToRename) + "#";
                } else {
                    ExecutionEnvironment env = RemotePlainFile.this.getExecutionEnvironment();
                    if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                        throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(env));
                    }
                    pathToRename = null;
                    pathToUpload = RemotePlainFile.this.getPath();
                }
                try {
                    DirEntry dirEntry = RemoteFileSystemTransport.uploadAndRename(RemotePlainFile.this.getExecutionEnvironment(), RemotePlainFile.this.getCache(), pathToUpload, pathToRename);
                    RemotePlainFile.this.updateStatAndSendEvents(dirEntry, false);
                }
                catch (TimeoutException ex) {
                    throw new IOException(ex);
                }
                catch (InterruptedException ex) {
                    throw this.newIOException(ex);
                }
                catch (ExecutionException ex) {
                    if (!ConnectionManager.getInstance().isConnectedTo(RemotePlainFile.this.getExecutionEnvironment())) {
                        RemotePlainFile.this.getFileSystem().addPendingFile(RemotePlainFile.this);
                        throw RemoteExceptions.createConnectException(ex.getMessage());
                    }
                    if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                        throw RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_DoesNotExist", (Object)RemotePlainFile.this.getDisplayName()));
                    }
                    if (ex.getCause() instanceof IOException) {
                        throw (IOException)ex.getCause();
                    }
                    throw this.newIOException(ex);
                }
                this.closed = true;
            }
            finally {
                RemotePlainFile.this.getLockSupport().writeUnlock(RemotePlainFile.this);
            }
        }

        private IOException newIOException(Exception cause) {
            return RemoteExceptions.createIOException(NbBundle.getMessage(RemotePlainFile.class, (String)"EXC_ErrorUploading", (Object)RemotePlainFile.this.getCache().getAbsolutePath(), (Object)RemotePlainFile.this.getExecutionEnvironment(), (Object)cause.getMessage()), cause);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }
    }

    private final class InputStreamWrapper
    extends InputStream {
        private final InputStream is;
        private boolean closed;
        private final Runnable postClose;

        public InputStreamWrapper(InputStream is, Runnable postClose) {
            this.is = is;
            this.postClose = postClose;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.is.close();
                this.closed = true;
            }
            finally {
                this.postClose.run();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public boolean equals(Object obj) {
            return this.is.equals(obj);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }
    }
}

