/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public interface std_ptr {
    public static <T> boolean $eq_shared_ptr(shared_ptr<T> primary, shared_ptr<T> second) {
        return std_ptr.$eq_shared_ptr$C(primary, second);
    }

    public static <T> boolean $eq_shared_ptr$C(shared_ptr<T> primary, shared_ptr<T> second) {
        if (primary == second) {
            return true;
        }
        return primary.$eq(second);
    }

    public static <T> boolean $eq_unique_ptr(unique_ptr<T> primary, unique_ptr<T> second) {
        return std_ptr.$eq_unique_ptr$C(primary, second);
    }

    public static <T> boolean $eq_unique_ptr$C(unique_ptr<T> primary, unique_ptr<T> second) {
        if (primary == second) {
            return true;
        }
        return primary.$eq(second);
    }

    public static <T> boolean $eq_unique_ptr(unique_ptr_with_deleter<T> primary, unique_ptr_with_deleter<T> second) {
        return std_ptr.$eq_unique_ptr$C(primary, second);
    }

    public static <T> boolean $eq_unique_ptr$C(unique_ptr_with_deleter<T> primary, unique_ptr_with_deleter<T> second) {
        if (primary == second) {
            return true;
        }
        return primary.$eq(second);
    }

    public static class unique_ptr_null_eq<T extends Native.NativeComparable>
    implements Destructors.ClassWithDestructor {
        private boolean destroyed = false;
        private T Ptr;
        private static long instances = 0L;

        private void checkAlive() {
            if (NativeTrace.isDebugMode() && this.destroyed) {
                throw new IllegalStateException("Already destroyed");
            }
        }

        private unique_ptr_null_eq(unique_ptr_null_eq<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        private unique_ptr_null_eq<T> $assign(unique_ptr_null_eq<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        public unique_ptr_null_eq() {
            this((Native.NativeComparable)null);
        }

        public unique_ptr_null_eq(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this((Native.NativeComparable)__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_null_eq(T P) {
            this.Ptr = P;
            assert (P == null || Native.$eq(P, null)) : "this object is not $eq to null, use OwningPtr instead";
            unique_ptr_null_eq.trackInstance();
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            if (this.Ptr != null) {
                Destructors.$destroy(this.Ptr);
            }
            this.destroyed = true;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(T P) {
            this.checkAlive();
            if (P == this.Ptr) {
                return;
            }
            assert (P == null || Native.$eq(P, null)) : "this object is not $eq to null, use OwningPtr instead";
            T Tmp = this.Ptr;
            this.Ptr = P;
            if (Tmp != null) {
                Destructors.$destroy(Tmp);
            }
        }

        public T take() {
            this.checkAlive();
            T Tmp = this.Ptr;
            this.Ptr = null;
            return Tmp;
        }

        public T $star() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T $arrow() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T get() {
            this.checkAlive();
            return this.Ptr;
        }

        public boolean $bool() {
            if (this.destroyed) {
                return false;
            }
            return this.Ptr == null ? false : Native.$noteq(this.Ptr, null);
        }

        public boolean $not() {
            if (this.destroyed) {
                return true;
            }
            return this.Ptr == null ? true : Native.$eq(this.Ptr, null);
        }

        public boolean isValid() {
            return this.Ptr == null ? false : Native.$noteq(this.Ptr, null);
        }

        public void swap(unique_ptr_null_eq<T> RHS) {
            this.checkAlive();
            T Tmp = RHS.Ptr;
            RHS.Ptr = this.Ptr;
            this.Ptr = Tmp;
        }

        public String toString() {
            return "unique_ptr_null_eq{destroyed=" + this.destroyed + ", Ptr=" + this.Ptr + '}';
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:\t%s%n", unique_ptr_null_eq.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr_null_eq.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class unique_ptr_array<T>
    extends unique_ptr<T[]> {
        private static long instances = 0L;

        public unique_ptr_array(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this((Object[])__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_array() {
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(T[] P) {
            super(P);
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(unique_ptr $Prm0) {
            super($Prm0);
            assert ($Prm0.getClass() == unique_ptr_array.class) : "Copy constructor called for different class!";
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(JavaDifferentiators.JD.Move _dparam, unique_ptr<T[]> $Prm0) {
            super(_dparam, $Prm0);
            assert ($Prm0.getClass() == unique_ptr_array.class) : "Move constructor called for different class!";
            unique_ptr_array.trackInstance();
        }

        @Override
        public unique_ptr_array<T> $assignMove(unique_ptr<T[]> __u) {
            super.$assignMove(__u);
            assert (__u.getClass() == unique_ptr_array.class) : "Move constructor called for different class!";
            return this;
        }

        public T $set(int i, T val) {
            ((Object[])this.get())[i] = Native.$tryAssign(((Object[])this.get())[i], val, true);
            return (T)((Object[])this.get())[i];
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:%s%n", unique_ptr_array.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr_array.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class unique_ptr_with_deleter<T>
    extends unique_ptr<T> {
        private final deleter<T> _Dp;
        private static long instances = 0L;

        public unique_ptr_with_deleter(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_with_deleter() {
            this._Dp = new default_delete();
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(T P) {
            super(P);
            this._Dp = new default_delete();
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(T P, deleter<T> _Dp) {
            super(P);
            this._Dp = _Dp;
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(unique_ptr $Prm0) {
            super($Prm0);
            assert ($Prm0.getClass() == unique_ptr_with_deleter.class) : "Copy constructor called for different class!";
            this._Dp = ((unique_ptr_with_deleter)$Prm0)._Dp;
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(JavaDifferentiators.JD.Move _dparam, unique_ptr<T> $Prm0) {
            super(_dparam, $Prm0);
            assert ($Prm0.getClass() == unique_ptr_with_deleter.class) : "Move constructor called for different class!";
            this._Dp = ((unique_ptr_with_deleter)$Prm0)._Dp;
            unique_ptr_with_deleter.trackInstance();
        }

        @Override
        public unique_ptr<T> $assignMove(unique_ptr<T> __u) {
            super.$assignMove(__u);
            assert (__u.getClass() == unique_ptr_with_deleter.class) : "Move constructor called for different class!";
            assert (this._Dp.getClass() == ((unique_ptr_with_deleter)__u)._Dp.getClass()) : "Moving to the ptr with differnet deleter!";
            return this;
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            this._Dp.$call(this.get());
            this.destroyed = true;
            if (NativeTrace.CHECK_STD_PTR_ACCESS) {
                this.destroyedStack = new Exception("First destroyed was at");
            }
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:%s%n", unique_ptr_with_deleter.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr_with_deleter.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class unique_ptr<T>
    implements Destructors.ClassWithDestructor,
    NativeMoveable<unique_ptr<T>>,
    NativeCloneable<unique_ptr<T>>,
    Native.NativeComparable<unique_ptr<T>> {
        private final Exception createdStack;
        protected Exception destroyedStack = null;
        protected boolean destroyed = false;
        private T Ptr;
        private static long instances = 0L;

        protected void checkAlive() {
            if ((NativeTrace.isDebugMode() || NativeTrace.CHECK_STD_PTR_ACCESS) && this.destroyed) {
                if (NativeTrace.CHECK_STD_PTR_ACCESS) {
                    NativeTrace.printStackTraceOnce(this.destroyedStack);
                    NativeTrace.printStackTraceOnce(this.createdStack);
                }
                throw new IllegalStateException("Already destroyed");
            }
        }

        public static <T> unique_ptr<T> $unique_ptr(unique_ptr<T> $Prm0) {
            return new unique_ptr<T>($Prm0.release());
        }

        public static <T> unique_ptr_with_deleter<T> $unique_ptr_with_deleter(unique_ptr_with_deleter<T> $Prm0) {
            return new unique_ptr_with_deleter<T>($Prm0.release(), ((unique_ptr_with_deleter)$Prm0)._Dp);
        }

        private unique_ptr<T> $assign(unique_ptr<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        public unique_ptr() {
            this(null);
        }

        public unique_ptr(T P) {
            this.Ptr = P;
            assert (P == null || Native.$noteq(P, null)) : "this object is $eq to null, use OwningPtrNullEq instead";
            this.createdStack = NativeTrace.CHECK_STD_PTR_ACCESS ? new Exception("created for " + (this.Ptr == null ? "<null>" : this.Ptr.getClass().getName())) : null;
            unique_ptr.trackInstance();
        }

        public unique_ptr(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public <X> unique_ptr(unique_ptr<X> $Prm0) {
            this.Ptr = $Prm0.release();
            this.createdStack = NativeTrace.CHECK_STD_PTR_ACCESS ? new Exception("created for " + (this.Ptr == null ? "<null>" : this.Ptr.getClass().getName())) : null;
            unique_ptr.trackInstance();
        }

        public <X> unique_ptr(JavaDifferentiators.JD.Move _dparam, unique_ptr<X> $Prm0) {
            this($Prm0.release());
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            if (this.Ptr != null) {
                Destructors.$destroy(this.Ptr);
            }
            this.destroyed = true;
            this.Ptr = null;
            if (NativeTrace.CHECK_STD_PTR_ACCESS) {
                this.destroyedStack = new Exception("First destroyed was at");
            }
        }

        public unique_ptr<T> $assignMove(unique_ptr<T> __u) {
            this.reset(__u.release());
            return this;
        }

        public unique_ptr<T> $assign_nullptr_t(Object obj) {
            assert (obj == null) : "Operator can be used only to assign nullptr_t!";
            this.reset();
            return this;
        }

        public unique_ptr<T> $assign$ConvertibleNotArray(Object obj) {
            assert (obj == null) : "Operator can be used only to assign nullptr_t!";
            this.reset();
            return this;
        }

        public T release() {
            T result = this.get();
            this.Ptr = null;
            return result;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(T P) {
            this.checkAlive();
            if (P == this.Ptr) {
                return;
            }
            T Tmp = this.Ptr;
            this.Ptr = P;
            assert (P == null || Native.$noteq(P, null)) : "this object is $eq to null, use OwningPtrNullEq instead";
            if (Tmp != null) {
                Destructors.$destroy(Tmp);
            }
        }

        public T take() {
            this.checkAlive();
            T Tmp = this.Ptr;
            this.Ptr = null;
            return Tmp;
        }

        public T $star() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        @Override
        public unique_ptr<T> clone() {
            assert (this.Ptr == null) : "Only empty unique_ptr can be cloned!";
            return new unique_ptr<T>();
        }

        @Override
        public unique_ptr<T> move() {
            return new unique_ptr<T>(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        public type$ref<T> star$ref() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return new type$ref<T>(){

                @Override
                public T $deref() {
                    return Ptr;
                }

                @Override
                public T $set(T value) {
                    Ptr = Native.$tryAssign(Ptr, value, false);
                    return Ptr;
                }

                @Override
                public type$ptr<T> deref$ptr() {
                    throw new UnsupportedOperationException("Not implemented yet!");
                }
            };
        }

        public T $arrow() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T get() {
            this.checkAlive();
            return this.Ptr;
        }

        public boolean $bool() {
            if (this.destroyed) {
                return false;
            }
            return this.Ptr != null;
        }

        public boolean $not() {
            if (this.destroyed) {
                return true;
            }
            return this.Ptr == null;
        }

        public boolean isValid() {
            return this.Ptr != null;
        }

        public void swap(unique_ptr<T> RHS) {
            this.checkAlive();
            T Tmp = RHS.Ptr;
            RHS.Ptr = this.Ptr;
            this.Ptr = Tmp;
        }

        @Override
        public boolean $eq(unique_ptr<T> other) {
            if (other == null) {
                return Native.$eq(this.Ptr, null, true);
            }
            return Native.$eq(this.Ptr, other.Ptr);
        }

        public String toString() {
            return "unique_ptr{destroyed=" + this.destroyed + ", Ptr=" + this.Ptr + '}';
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:\t%s%n", unique_ptr.class.getSimpleName() + "(+derived)", NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class shared_ptr<T>
    implements Destructors.ClassWithDestructor,
    Native.NativeComparable<shared_ptr<T>> {
        private T Obj;
        private AtomicInteger _M_refcount;
        private static long instances = 0L;

        public shared_ptr() {
            this.Obj = null;
            this._M_refcount = null;
            shared_ptr.trackInstance();
        }

        public shared_ptr(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public shared_ptr(T obj) {
            this.Obj = obj;
            this.retain();
            shared_ptr.trackInstance();
        }

        public shared_ptr(shared_ptr<T> S) {
            this.Obj = S.Obj;
            this._M_refcount = new AtomicInteger(0);
            this.retain();
            shared_ptr.trackInstance();
        }

        public shared_ptr(JavaDifferentiators.JD.Move $Prm, shared_ptr<T> S) {
            this.Obj = null;
            this._M_refcount = null;
            this.swap(S);
        }

        public shared_ptr<T> $assign(shared_ptr<T> S) {
            if (this != S) {
                this.release();
                this.Obj = S.Obj;
                this._M_refcount = S._M_refcount;
                this.retain();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public shared_ptr<T> $assignMove(shared_ptr<T> S) {
            shared_ptr<T> tmp = new shared_ptr<T>(JavaDifferentiators.JD.Move.INSTANCE, S);
            try {
                tmp.swap(this);
                shared_ptr shared_ptr2 = this;
                return shared_ptr2;
            }
            finally {
                tmp.$destroy();
            }
        }

        @Override
        public void $destroy() {
            this.release();
        }

        public T $star() {
            return this.Obj;
        }

        public T $arrow() {
            return this.Obj;
        }

        public T getPtr() {
            return this.Obj;
        }

        public boolean $bool() {
            return this.Obj != null;
        }

        public T $Void2Type() {
            return this.Obj == null ? null : (T)this.Obj;
        }

        public void swap(shared_ptr<T> other) {
            T tmp = other.Obj;
            AtomicInteger _M_refcount_Tmp = other._M_refcount;
            other.Obj = this.Obj;
            other._M_refcount = this._M_refcount;
            this.Obj = tmp;
            this._M_refcount = _M_refcount_Tmp;
        }

        public void reset() {
            this.release();
            this.Obj = null;
        }

        public void resetWithoutRelease() {
            this.Obj = null;
        }

        private void retain() {
            if (this.Obj != null) {
                if (this._M_refcount == null) {
                    this._M_refcount = new AtomicInteger(0);
                }
                this._M_refcount.incrementAndGet();
            }
        }

        private void release() {
            if (this.Obj != null) {
                assert (this._M_refcount != null);
                if (this._M_refcount.decrementAndGet() == 0) {
                    Destructors.$destroy(this.Obj);
                    this.Obj = null;
                    this._M_refcount = null;
                }
            }
        }

        public String toString() {
            return "shared_ptr{counter=" + this._M_refcount + ", Obj=" + this.Obj + '}';
        }

        public T get() {
            return this.Obj;
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:\t%s%n", shared_ptr.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(shared_ptr.class.getSimpleName(), instances);
            return instances;
        }

        @Override
        public boolean $eq(shared_ptr<T> other) {
            if (other == null) {
                return Native.$eq(this.Obj, null);
            }
            return Native.$eq(this.Obj, other.Obj);
        }
    }

    public static class default_delete<T>
    implements deleter<T> {
        @Override
        public void $call(T __ptr) {
            Native.destroy(__ptr);
        }
    }

    public static interface deleter<T> {
        public void $call(T var1);
    }
}

