/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.apt;

import com.sun.tools.jxc.apt.Messages;
import com.sun.tools.xjc.BadCommandLineException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Options {
    public String classpath = System.getenv("CLASSPATH");
    public File targetDir = null;
    public File episodeFile = null;
    public String encoding = null;
    public final List<String> arguments = new ArrayList<String>();

    public void parseArguments(String[] args) throws BadCommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                int j = this.parseArgument(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(Messages.UNRECOGNIZED_PARAMETER.format(args[i]));
                }
                i += j;
                continue;
            }
            this.arguments.add(args[i]);
        }
    }

    private int parseArgument(String[] args, int i) throws BadCommandLineException {
        if (args[i].equals("-d")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(args[i]));
            }
            this.targetDir = new File(args[++i]);
            if (!this.targetDir.exists()) {
                throw new BadCommandLineException(Messages.NON_EXISTENT_FILE.format(this.targetDir));
            }
            return 1;
        }
        if (args[i].equals("-episode")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(args[i]));
            }
            this.episodeFile = new File(args[++i]);
            return 1;
        }
        if (args[i].equals("-encoding")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(args[i]));
            }
            this.encoding = args[++i];
            return 1;
        }
        if (args[i].equals("-cp") || args[i].equals("-classpath")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(args[i]));
            }
            this.classpath = args[++i];
            return 1;
        }
        return 0;
    }
}

