/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesListController;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.ui.CollapsibleSplitPane;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.Lookup;

public class InstancesListControllerUI
extends JTitledPanel {
    private static KeyStroke COPY_ID_KEYSTROKE = KeyStroke.getKeyStroke(67, 640);
    private static Icon ICON_INSTANCES = Icons.getIcon((String)"HeapWalkerIcons.Instances");
    private int columnCount;
    private ExtendedTreeTableModel instancesListTableModel;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer(true);
    private Instance instanceToSelect = null;
    private InstancesListController instancesListController;
    private InstancesListTreeTableModel realInstancesListModel;
    private boolean retainedSizeSupported;
    private JPanel dataPanel;
    private JPopupMenu tablePopup;
    private JPopupMenu cornerPopup;
    private JTreeTable instancesListTable;
    private String filterValue = "";
    private String selectedRowContents;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean selectionSaved = false;
    private boolean sorting = false;
    private boolean sortingOrder = false;
    private int selectedRow;
    private int sortingColumn = 2;

    public InstancesListControllerUI(InstancesListController instancesListController) {
        super(Bundle.InstancesListControllerUI_ViewCaption(), ICON_INSTANCES, true);
        this.instancesListController = instancesListController;
        this.retainedSizeSupported = instancesListController.getInstancesController().getHeapFragmentWalker().getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 4 : 3;
        this.realInstancesListModel = new InstancesListTreeTableModel();
        this.instancesListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realInstancesListModel);
        this.initColumnsData();
        this.initData();
        this.initComponents();
        instancesListController.getInstancesController().getHeapFragmentWalker().addStateListener(new HeapFragmentWalker.StateListener(){

            @Override
            public void stateChanged(HeapFragmentWalker.StateEvent e) {
                if (e.getRetainedSizesStatus() == 3 && e.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InstancesListControllerUI.this.instancesListTableModel.setRealColumnVisibility(3, true);
                            InstancesListControllerUI.this.instancesListTable.createDefaultColumnsFromModel();
                            InstancesListControllerUI.this.instancesListTable.updateTreeTableHeader();
                            InstancesListControllerUI.this.setColumnsData();
                        }
                    });
                }
            }
        });
    }

    public void initColumns() {
        if (this.instancesListTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaClass selectedClass = InstancesListControllerUI.this.instancesListController.getInstancesController().getSelectedClass();
                    if (selectedClass != null && selectedClass.isArray()) {
                        if (!InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(2)) {
                            InstancesListControllerUI.this.toggleColumnVisibility(2, false);
                        }
                    } else if (InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(2)) {
                        InstancesListControllerUI.this.toggleColumnVisibility(2, false);
                    }
                    if (InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(1)) {
                        InstancesListControllerUI.this.toggleColumnVisibility(1, false);
                    }
                }
            });
        }
    }

    public void makeVisible() {
        if (!this.isShowing()) {
            this.setVisible(true);
        }
    }

    public void refreshView() {
        if (this.instancesListTable != null) {
            HeapWalkerNode root = (HeapWalkerNode)((Object)this.instancesListTableModel.getRoot());
            this.instancesListTable.getTree().setShowsRootHandles(root instanceof InstancesListController.InstancesListClassNode && root.getChild(0) instanceof InstancesListController.InstancesListContainerNode);
            this.instancesListTable.changeRoot((CCTNode)root);
        }
    }

    public void selectInstance(Instance instance) {
        if (this.displaysFlatInstances()) {
            this.selectFlatInstance(instance);
        } else if (this.displaysCollapsedInstances()) {
            this.selectCollapsedInstance(instance);
        }
    }

    public void selectPath(TreePath pathToSelect) {
        if (this.instancesListTable == null) {
            return;
        }
        final TreePath pathToSelectFinal = pathToSelect;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!InstancesListControllerUI.this.isShowing()) {
                    InstancesListControllerUI.this.setVisible(true);
                }
                InstancesListControllerUI.this.instancesListTable.getTree().setSelectionPath(pathToSelectFinal);
                final Rectangle pathToSelectBounds = InstancesListControllerUI.this.instancesListTable.getTree().getPathBounds(pathToSelectFinal);
                if (pathToSelectBounds != null) {
                    InstancesListControllerUI.this.instancesListTable.scrollRectToVisible(pathToSelectBounds);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InstancesListControllerUI.this.instancesListTable.scrollRectToVisible(pathToSelectBounds);
                        }
                    });
                }
                if (InstancesListControllerUI.this.sorting) {
                    InstancesListControllerUI.this.sorting = false;
                }
            }
        });
    }

    public void update() {
        this.update(false);
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realInstancesListModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.realInstancesListModel.getColumnName(i));
            menuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.instancesListTable != null) {
                menuItem.setState(this.instancesListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.instancesListTable.getColumnModel();
        this.instancesListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.instancesListTableModel.getColumnCount(); ++i) {
            int index = this.instancesListTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem menuItem) {
        final boolean[] internalChange = new boolean[1];
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (internalChange[0]) {
                    return;
                }
                final int column = Integer.parseInt(e.getActionCommand());
                if (column == 3 && !InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(column)) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            final int retainedSizesState = InstancesListControllerUI.this.instancesListController.getInstancesController().getHeapFragmentWalker().computeRetainedSizes(false, true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (retainedSizesState != 3) {
                                        internalChange[0] = true;
                                        menuItem.setSelected(!menuItem.isSelected());
                                        internalChange[0] = false;
                                    } else {
                                        InstancesListControllerUI.this.toggleColumnVisibility(column, true);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    InstancesListControllerUI.this.toggleColumnVisibility(column, true);
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu headerPopup) {
        final JButton cornerButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        cornerButton.setToolTipText(Bundle.InstancesListControllerUI_ShowHideColumnsString());
        cornerButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 1));
        }
        cornerButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    InstancesListControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        cornerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (headerPopup.isVisible()) {
                    InstancesListControllerUI.this.internalCornerButtonClick = true;
                    cornerButton.getModel().setArmed(false);
                } else {
                    InstancesListControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        InstancesListControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !InstancesListControllerUI.this.internalCornerButtonClick) {
                    InstancesListControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        return cornerButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem showGcRootItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_ShowGcRootItemText());
        showGcRootItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancesListControllerUI.this.instancesListController.getInstancesController().getReferencesBrowserController().navigateToRootNearestGCRoot();
            }
        });
        popup.add(showGcRootItem);
        popup.addSeparator();
        JMenuItem copyIdItem = new JMenuItem(Bundle.InstancesListControllerUI_CopyIdString());
        copyIdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancesListControllerUI.this.copyIdToClipboard();
            }
        });
        copyIdItem.setAccelerator(COPY_ID_KEYSTROKE);
        popup.add(copyIdItem);
        return popup;
    }

    private void showTablePopup(Component invoker, int x, int y) {
        if (this.instancesListController.getSelectedInstance() != null) {
            this.tablePopup.show(invoker, x, y);
        }
    }

    private void copyIdToClipboard() {
        Instance instance = this.instancesListController.getSelectedInstance();
        if (instance == null) {
            return;
        }
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        clipboard.setContents(new StringSelection("0x" + Long.toHexString(instance.getInstanceId())), null);
    }

    private boolean displaysCollapsedInstances() {
        HeapWalkerNode root = (HeapWalkerNode)((Object)this.instancesListTableModel.getRoot());
        return root != null && root.getNChildren() > 0 && root.getChild(0) instanceof InstancesListController.InstancesListContainerNode;
    }

    private boolean displaysFlatInstances() {
        HeapWalkerNode root = (HeapWalkerNode)((Object)this.instancesListTableModel.getRoot());
        return root != null && root.getNChildren() > 0 && root.getChild(0) instanceof InstancesListController.InstancesListInstanceNode;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = Bundle.InstancesListControllerUI_InstanceColumnName();
        this.columnToolTips[0] = Bundle.InstancesListControllerUI_InstanceColumnDescr();
        this.columnNames[1] = Bundle.InstancesListControllerUI_ObjidColumnName();
        this.columnToolTips[1] = Bundle.InstancesListControllerUI_ObjidColumnDescr();
        this.columnNames[2] = Bundle.InstancesListControllerUI_SizeColumnName();
        this.columnToolTips[2] = Bundle.InstancesListControllerUI_SizeColumnDescr();
        if (this.retainedSizeSupported) {
            this.columnNames[3] = Bundle.InstancesListControllerUI_RetainedSizeColumnName();
            this.columnToolTips[3] = Bundle.InstancesListControllerUI_RetainedSizeColumnDescr();
        }
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 7;
        LabelTableCellRenderer dataCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = dataCellRenderer;
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = dataCellRenderer;
        if (this.retainedSizeSupported) {
            this.columnWidths[2] = maxWidth;
            this.columnRenderers[3] = dataCellRenderer;
        }
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        if (this.retainedSizeSupported) {
            this.instancesListTableModel.setRealColumnVisibility(3, this.instancesListController.getInstancesController().getHeapFragmentWalker().getRetainedSizesStatus() == 3);
        }
        this.instancesListTable = new JTreeTable((AbstractTreeTableModel)this.instancesListTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < InstancesListControllerUI.this.instancesListTableModel.getColumnCount(); ++i) {
                    if (InstancesListControllerUI.this.instancesListTableModel.getRealColumn(i) == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(this.getWidth() - columnsWidthsSum);
                }
                super.doLayout();
            }
        };
        this.instancesListTable.getTree().setRootVisible(false);
        this.instancesListTable.addMouseListener((MouseListener)new InstancesListTableMouseListener());
        this.instancesListTable.addKeyListener((KeyListener)new InstancesListTableKeyListener());
        this.instancesListTable.setSelectionMode(0);
        this.instancesListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.instancesListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.instancesListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.instancesListTable.setShowHorizontalLines(false);
        this.instancesListTable.setShowVerticalLines(true);
        this.instancesListTable.setRowMargin(0);
        this.instancesListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.instancesListTable.getTree().setLargeModel(true);
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.instancesListTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.instancesListTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.instancesListTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.instancesListTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel tablePanel = new JTreeTablePanel(this.instancesListTable);
        tablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setLayout(new BorderLayout());
        Heap heap = this.instancesListController.getInstancesController().getHeapFragmentWalker().getHeapFragment();
        final InstanceScrollPane scroll = new InstanceScrollPane(heap);
        this.add(new CollapsibleSplitPane((Component)tablePanel, scroll), "Center");
        this.instancesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = InstancesListControllerUI.this.instancesListTable.getSelectedRow();
                if (InstancesListControllerUI.this.sorting || e.getValueIsAdjusting() || selectedRow == -1) {
                    return;
                }
                Instance selectedInstance = null;
                if (selectedRow != -1) {
                    HeapWalkerNode selectedNode;
                    TreePath selectedPath = InstancesListControllerUI.this.instancesListTable.getTree().getPathForRow(selectedRow);
                    HeapWalkerNode heapWalkerNode = selectedNode = selectedPath == null ? null : (HeapWalkerNode)((Object)selectedPath.getLastPathComponent());
                    if (selectedNode instanceof InstancesListController.InstancesListInstanceNode) {
                        selectedInstance = ((InstancesListController.InstancesListInstanceNode)selectedNode).getInstance();
                    }
                }
                scroll.showInstance(selectedInstance);
                InstancesListControllerUI.this.instancesListController.instanceSelected(selectedInstance);
            }
        });
        this.setPreferredSize(new Dimension(275, 500));
    }

    private void initData() {
        this.instancesListTableModel.setRoot((Object)this.instancesListController.getFilteredSortedInstances(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void restoreSelection() {
        if (this.selectedRowContents != null) {
            this.instancesListTable.selectRowByContents(this.selectedRowContents, 0, true);
        }
        this.selectionSaved = false;
    }

    private void saveSelection() {
        if (this.selectionSaved) {
            return;
        }
        this.selectedRow = this.instancesListTable == null ? -1 : this.instancesListTable.getSelectedRow();
        this.selectedRowContents = null;
        if (this.selectedRow != -1) {
            this.selectedRowContents = this.instancesListTable.getValueAt(this.selectedRow, 0).toString();
        }
        this.selectionSaved = true;
    }

    private void selectCollapsedInstance(Instance instance) {
        HeapWalkerNode root = (HeapWalkerNode)((Object)this.instancesListTableModel.getRoot());
        if (root instanceof InstancesListController.InstancesListNode) {
            InstancesListController.InstancesListNode instancesListRoot = (InstancesListController.InstancesListNode)((Object)root);
            TreePath instancePath = instancesListRoot.getInstancePath(instance);
            if (instancePath != null) {
                this.selectPath(instancePath);
            } else {
                HeapWalkerNode instanceContainer = this.instancesListController.getInstanceContainer(instance, (InstancesListController.InstancesListClassNode)root);
                if (instanceContainer != null) {
                    this.instancesListController.scheduleInstanceSelection(instance);
                    instanceContainer.getChildren();
                }
            }
        }
    }

    private void selectFlatInstance(Instance instance) {
        InstancesListController.InstancesListNode instancesListRoot;
        TreePath instancePath;
        HeapWalkerNode root = (HeapWalkerNode)((Object)this.instancesListTableModel.getRoot());
        if (root instanceof InstancesListController.InstancesListNode && (instancePath = (instancesListRoot = (InstancesListController.InstancesListNode)((Object)root)).getInstancePath(instance)) != null) {
            this.selectPath(instancePath);
        }
    }

    private void showColumnSelectionPopup(JPopupMenu headerPopup, JButton cornerButton) {
        this.initColumnSelectorItems();
        headerPopup.show(cornerButton, cornerButton.getWidth() - headerPopup.getPreferredSize().width, cornerButton.getHeight());
    }

    private void toggleColumnVisibility(int column, boolean reSort) {
        boolean sortResults = false;
        int currentSortingColumn = this.instancesListTable.getSortingColumn();
        int realSortingColumn = this.instancesListTableModel.getRealColumn(currentSortingColumn);
        boolean isColumnVisible = this.instancesListTableModel.isRealColumnVisible(column);
        if (isColumnVisible && column == realSortingColumn) {
            currentSortingColumn = currentSortingColumn + 1 == this.instancesListTableModel.getColumnCount() ? currentSortingColumn - 1 : currentSortingColumn + 1;
            realSortingColumn = this.instancesListTableModel.getRealColumn(currentSortingColumn);
            sortResults = true;
        }
        this.instancesListTableModel.setRealColumnVisibility(column, !isColumnVisible);
        this.instancesListTable.createDefaultColumnsFromModel();
        this.instancesListTable.updateTreeTableHeader();
        currentSortingColumn = this.instancesListTableModel.getVirtualColumn(realSortingColumn);
        if (sortResults) {
            if (reSort) {
                this.instancesListTableModel.sortByColumn(currentSortingColumn, this.instancesListTableModel.getInitialSorting(currentSortingColumn));
            } else {
                this.sortingOrder = this.instancesListTableModel.getInitialSorting(currentSortingColumn);
                this.sortingColumn = currentSortingColumn;
            }
            this.instancesListTable.updateTreeTable();
        }
        this.instancesListTable.setSortingColumn(currentSortingColumn);
        this.instancesListTable.setSortingOrder(this.sortingOrder);
        this.instancesListTable.getTableHeader().repaint();
        this.setColumnsData();
    }

    private void update(boolean fromSorting) {
        this.makeVisible();
        this.initData();
        if (!fromSorting && this.instancesListTable != null) {
            this.instancesListTable.resetTreeCellOffsetX();
        }
    }

    private static class InstanceScrollPane
    extends JScrollPane {
        private final Heap heap;
        private Instance selectedInstance = null;
        private boolean instancePending = false;

        InstanceScrollPane(Heap heap) {
            this.heap = heap;
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setViewportBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow")));
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && InstanceScrollPane.this.instancePending && InstanceScrollPane.this.isShowing()) {
                        InstanceScrollPane.this.showInstanceImpl();
                    }
                }
            });
        }

        void showInstance(Instance instance) {
            if (this.selectedInstance == instance) {
                return;
            }
            this.selectedInstance = instance;
            if (this.isShowing()) {
                this.showInstanceImpl();
            } else {
                this.instancePending = true;
            }
        }

        private void showInstanceImpl() {
            JComponent instanceView;
            JComponent jComponent = instanceView = this.selectedInstance == null ? null : DetailsSupport.getDetailsView(this.selectedInstance, this.heap);
            if (instanceView == null) {
                instanceView = new JLabel(Bundle.InstancesListControllerUI_NoDetails(), 0);
                instanceView.setEnabled(false);
            }
            this.setViewportView(instanceView);
            this.instancePending = false;
        }
    }

    private class InstancesListTreeTableModel
    extends AbstractTreeTableModel {
        private InstancesListTreeTableModel() {
            super((CCTNode)InstancesListController.EMPTY_INSTANCE_NODE, true, InstancesListControllerUI.this.sortingColumn, InstancesListControllerUI.this.sortingOrder);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return InstancesListControllerUI.this.columnCount;
        }

        public String getColumnName(int columnIndex) {
            return InstancesListControllerUI.this.columnNames[columnIndex];
        }

        public String getColumnToolTipText(int col) {
            return InstancesListControllerUI.this.columnToolTips[col];
        }

        public boolean getInitialSorting(int column) {
            switch (column) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        public boolean isLeaf(Object node) {
            return ((HeapWalkerNode)((Object)node)).isLeaf();
        }

        public Object getValueAt(Object object, int columnIndex) {
            if (object instanceof InstancesListController.InstancesListNode) {
                InstancesListController.InstancesListNode node = (InstancesListController.InstancesListNode)object;
                switch (columnIndex) {
                    case 0: {
                        return node;
                    }
                    case 1: {
                        return node.getID();
                    }
                    case 2: {
                        return node.getSize();
                    }
                    case 3: {
                        return node.getRetainedSize();
                    }
                }
                return null;
            }
            HeapWalkerNode node = (HeapWalkerNode)((Object)object);
            switch (columnIndex) {
                case 0: {
                    return node;
                }
            }
            return "";
        }

        public void sortByColumn(int column, boolean order) {
            HeapWalkerNode selectedNode;
            int selectedRow;
            InstancesListControllerUI.this.sortingColumn = column;
            InstancesListControllerUI.this.sortingOrder = order;
            Instance selectedInstance = InstancesListControllerUI.this.instancesListController.getSelectedInstance();
            if (selectedInstance != null) {
                InstancesListControllerUI.this.instancesListController.scheduleInstanceSelection(selectedInstance);
            } else if (InstancesListControllerUI.this.instancesListTable != null && (selectedRow = InstancesListControllerUI.this.instancesListTable.getSelectedRow()) != -1 && (selectedNode = (HeapWalkerNode)((Object)InstancesListControllerUI.this.instancesListTable.getTree().getPathForRow(selectedRow).getLastPathComponent())) instanceof InstancesListController.InstancesListContainerNode) {
                InstancesListControllerUI.this.instancesListController.scheduleContainerSelection(selectedNode.getParent().getIndexOfChild((Object)selectedNode));
            }
            if (InstancesListControllerUI.this.isShowing()) {
                InstancesListControllerUI.this.sorting = true;
            }
            InstancesListControllerUI.this.update(true);
        }
    }

    private class InstancesListTableMouseListener
    extends MouseAdapter {
        private InstancesListTableMouseListener() {
        }

        private void updateSelection(int row) {
            InstancesListControllerUI.this.instancesListTable.requestFocusInWindow();
            if (row != -1) {
                InstancesListControllerUI.this.instancesListTable.setRowSelectionInterval(row, row);
            } else {
                InstancesListControllerUI.this.instancesListTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = InstancesListControllerUI.this.instancesListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (row != -1 && e.isPopupTrigger()) {
                InstancesListControllerUI.this.showTablePopup(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = InstancesListControllerUI.this.instancesListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (row != -1 && e.isPopupTrigger()) {
                InstancesListControllerUI.this.showTablePopup(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class InstancesListTableKeyListener
    extends KeyAdapter {
        private InstancesListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
                int selectedRow = InstancesListControllerUI.this.instancesListTable.getSelectedRow();
                if (selectedRow != -1) {
                    Rectangle rowBounds = InstancesListControllerUI.this.instancesListTable.getCellRect(selectedRow, 0, true);
                    InstancesListControllerUI.this.showTablePopup((Component)InstancesListControllerUI.this.instancesListTable, rowBounds.x + rowBounds.width / 2, rowBounds.y + rowBounds.height / 2);
                }
            } else if (KeyStroke.getAWTKeyStroke(e.getKeyCode(), e.getModifiers()).equals(COPY_ID_KEYSTROKE)) {
                InstancesListControllerUI.this.copyIdToClipboard();
            }
        }
    }
}

