/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CndCollectionUtils {
    private CndCollectionUtils() {
    }

    public static int hashCode(Collection<?> col) {
        int hash = 0;
        if (col != null) {
            hash = 5;
            for (Object o : col) {
                hash = 67 * hash + Objects.hashCode(o);
            }
        }
        return hash;
    }

    public static int hashCode(Map<?, ?> thisCol) {
        int hash = 5;
        for (Object p : thisCol.keySet()) {
            hash ^= Objects.hashCode(p);
        }
        return hash;
    }

    public static boolean equals(Map<?, ?> thisCol, Map<?, ?> otherCol) {
        if (thisCol == otherCol) {
            return true;
        }
        if (thisCol == null != (otherCol == null)) {
            return false;
        }
        if (thisCol != null && otherCol != null) {
            if (thisCol.size() != otherCol.size()) {
                return false;
            }
            for (Map.Entry<?, ?> entry : thisCol.entrySet()) {
                Object otherVal = otherCol.get(entry.getKey());
                if (Objects.equals(entry.getValue(), otherVal)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(List<?> thisCol, List<?> otherCol) {
        if (thisCol == otherCol) {
            return true;
        }
        if (thisCol == null != (otherCol == null)) {
            return false;
        }
        if (thisCol != null && otherCol != null) {
            if (thisCol.size() != otherCol.size()) {
                return false;
            }
            for (int i = 0; i < thisCol.size(); ++i) {
                if (Objects.equals(thisCol.get(i), otherCol.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Iterable<?> thisCol, Iterable<?> otherCol) {
        if (thisCol == otherCol) {
            return true;
        }
        if (thisCol == null != (otherCol == null)) {
            return false;
        }
        if (thisCol != null && otherCol != null) {
            Iterator<?> itThis = thisCol.iterator();
            Iterator<?> itOther = otherCol.iterator();
            while (itThis.hasNext()) {
                if (!itOther.hasNext()) {
                    return false;
                }
                if (Objects.equals(itThis.next(), itOther.next())) continue;
                return false;
            }
            if (itOther.hasNext()) {
                return false;
            }
        }
        return true;
    }
}

